package zio.aws.dynamodbstreams.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Record(
    eventID: Option[String] = None,
    eventName: Option[zio.aws.dynamodbstreams.model.OperationType] = None,
    eventVersion: Option[String] = None,
    eventSource: Option[String] = None,
    awsRegion: Option[String] = None,
    dynamodb: Option[zio.aws.dynamodbstreams.model.StreamRecord] = None,
    userIdentity: Option[zio.aws.dynamodbstreams.model.Identity] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Record
      .builder()
      .optionallyWith(eventID.map(value => value: java.lang.String))(_.eventID)
      .optionallyWith(eventName.map(value => value.unwrap))(_.eventName)
      .optionallyWith(eventVersion.map(value => value: java.lang.String))(
        _.eventVersion
      )
      .optionallyWith(eventSource.map(value => value: java.lang.String))(
        _.eventSource
      )
      .optionallyWith(awsRegion.map(value => value: java.lang.String))(
        _.awsRegion
      )
      .optionallyWith(dynamodb.map(value => value.buildAwsValue()))(_.dynamodb)
      .optionallyWith(userIdentity.map(value => value.buildAwsValue()))(
        _.userIdentity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.Record.ReadOnly =
    zio.aws.dynamodbstreams.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Record] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.Record =
      zio.aws.dynamodbstreams.model.Record(
        eventID.map(value => value),
        eventName.map(value => value),
        eventVersion.map(value => value),
        eventSource.map(value => value),
        awsRegion.map(value => value),
        dynamodb.map(value => value.asEditable),
        userIdentity.map(value => value.asEditable)
      )
    def eventID: Option[String]
    def eventName: Option[zio.aws.dynamodbstreams.model.OperationType]
    def eventVersion: Option[String]
    def eventSource: Option[String]
    def awsRegion: Option[String]
    def dynamodb: Option[zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly]
    def userIdentity: Option[zio.aws.dynamodbstreams.model.Identity.ReadOnly]
    def getEventID: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventID", eventID)
    def getEventName
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.OperationType] =
      AwsError.unwrapOptionField("eventName", eventName)
    def getEventVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventVersion", eventVersion)
    def getEventSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getAwsRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getDynamodb: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly
    ] = AwsError.unwrapOptionField("dynamodb", dynamodb)
    def getUserIdentity
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("userIdentity", userIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Record
  ) extends zio.aws.dynamodbstreams.model.Record.ReadOnly {
    override val eventID: Option[String] =
      scala.Option(impl.eventID()).map(value => value: String)
    override val eventName
        : Option[zio.aws.dynamodbstreams.model.OperationType] = scala
      .Option(impl.eventName())
      .map(value => zio.aws.dynamodbstreams.model.OperationType.wrap(value))
    override val eventVersion: Option[String] =
      scala.Option(impl.eventVersion()).map(value => value: String)
    override val eventSource: Option[String] =
      scala.Option(impl.eventSource()).map(value => value: String)
    override val awsRegion: Option[String] =
      scala.Option(impl.awsRegion()).map(value => value: String)
    override val dynamodb
        : Option[zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly] = scala
      .Option(impl.dynamodb())
      .map(value => zio.aws.dynamodbstreams.model.StreamRecord.wrap(value))
    override val userIdentity
        : Option[zio.aws.dynamodbstreams.model.Identity.ReadOnly] = scala
      .Option(impl.userIdentity())
      .map(value => zio.aws.dynamodbstreams.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Record
  ): zio.aws.dynamodbstreams.model.Record.ReadOnly = new Wrapper(impl)
}
