package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait TableClass {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.TableClass
}
object TableClass {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.TableClass
  ): zio.aws.dynamodb.model.TableClass = value match {
    case software.amazon.awssdk.services.dynamodb.model.TableClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.TableClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.dynamodb.model.TableClass.STANDARD_INFREQUENT_ACCESS =>
      val r = STANDARD_INFREQUENT_ACCESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.TableClass {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableClass =
      software.amazon.awssdk.services.dynamodb.model.TableClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.dynamodb.model.TableClass {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableClass =
      software.amazon.awssdk.services.dynamodb.model.TableClass.STANDARD
  }
  case object STANDARD_INFREQUENT_ACCESS
      extends zio.aws.dynamodb.model.TableClass {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableClass =
      software.amazon.awssdk.services.dynamodb.model.TableClass.STANDARD_INFREQUENT_ACCESS
  }
}
