package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  PositiveIntegerObject,
  IndexName,
  TableName,
  ProjectionExpression,
  AttributeName,
  ConsistentRead,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ScanTotalSegments,
  ScanSegment,
  ExpressionAttributeValueVariable
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ScanRequest(
    tableName: TableName,
    indexName: Optional[IndexName] = Optional.Absent,
    attributesToGet: Optional[Iterable[AttributeName]] = Optional.Absent,
    limit: Optional[PositiveIntegerObject] = Optional.Absent,
    select: Optional[zio.aws.dynamodb.model.Select] = Optional.Absent,
    scanFilter: Optional[Map[AttributeName, zio.aws.dynamodb.model.Condition]] =
      Optional.Absent,
    conditionalOperator: Optional[zio.aws.dynamodb.model.ConditionalOperator] =
      Optional.Absent,
    exclusiveStartKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = Optional.Absent,
    returnConsumedCapacity: Optional[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = Optional.Absent,
    totalSegments: Optional[ScanTotalSegments] = Optional.Absent,
    segment: Optional[ScanSegment] = Optional.Absent,
    projectionExpression: Optional[ProjectionExpression] = Optional.Absent,
    filterExpression: Optional[ConditionExpression] = Optional.Absent,
    expressionAttributeNames: Optional[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = Optional.Absent,
    expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = Optional.Absent,
    consistentRead: Optional[ConsistentRead] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ScanRequest = {
    import ScanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ScanRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(select.map(value => value.unwrap))(_.select)
      .optionallyWith(
        scanFilter.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.scanFilter)
      .optionallyWith(conditionalOperator.map(value => value.unwrap))(
        _.conditionalOperator
      )
      .optionallyWith(
        exclusiveStartKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.exclusiveStartKey)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(
        totalSegments.map(value => ScanTotalSegments.unwrap(value): Integer)
      )(_.totalSegments)
      .optionallyWith(segment.map(value => ScanSegment.unwrap(value): Integer))(
        _.segment
      )
      .optionallyWith(
        projectionExpression.map(value =>
          ProjectionExpression.unwrap(value): java.lang.String
        )
      )(_.projectionExpression)
      .optionallyWith(
        filterExpression.map(value =>
          ConditionExpression.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable.unwrap(
                key
              ): java.lang.String) -> (AttributeName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ScanRequest.ReadOnly =
    zio.aws.dynamodb.model.ScanRequest.wrap(buildAwsValue())
}
object ScanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ScanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ScanRequest =
      zio.aws.dynamodb.model.ScanRequest(
        tableName,
        indexName.map(value => value),
        attributesToGet.map(value => value),
        limit.map(value => value),
        select.map(value => value),
        scanFilter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conditionalOperator.map(value => value),
        exclusiveStartKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        returnConsumedCapacity.map(value => value),
        totalSegments.map(value => value),
        segment.map(value => value),
        projectionExpression.map(value => value),
        filterExpression.map(value => value),
        expressionAttributeNames.map(value => value),
        expressionAttributeValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consistentRead.map(value => value)
      )
    def tableName: TableName
    def indexName: Optional[IndexName]
    def attributesToGet: Optional[List[AttributeName]]
    def limit: Optional[PositiveIntegerObject]
    def select: Optional[zio.aws.dynamodb.model.Select]
    def scanFilter: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]
    ]
    def conditionalOperator
        : Optional[zio.aws.dynamodb.model.ConditionalOperator]
    def exclusiveStartKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def totalSegments: Optional[ScanTotalSegments]
    def segment: Optional[ScanSegment]
    def projectionExpression: Optional[ProjectionExpression]
    def filterExpression: Optional[ConditionExpression]
    def expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def consistentRead: Optional[ConsistentRead]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getSelect: ZIO[Any, AwsError, zio.aws.dynamodb.model.Select] =
      AwsError.unwrapOptionField("select", select)
    def getScanFilter: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.Condition.ReadOnly
    ]] = AwsError.unwrapOptionField("scanFilter", scanFilter)
    def getConditionalOperator
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionalOperator] =
      AwsError.unwrapOptionField("conditionalOperator", conditionalOperator)
    def getExclusiveStartKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("exclusiveStartKey", exclusiveStartKey)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getTotalSegments: ZIO[Any, AwsError, ScanTotalSegments] =
      AwsError.unwrapOptionField("totalSegments", totalSegments)
    def getSegment: ZIO[Any, AwsError, ScanSegment] =
      AwsError.unwrapOptionField("segment", segment)
    def getProjectionExpression: ZIO[Any, AwsError, ProjectionExpression] =
      AwsError.unwrapOptionField("projectionExpression", projectionExpression)
    def getFilterExpression: ZIO[Any, AwsError, ConditionExpression] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ScanRequest
  ) extends zio.aws.dynamodb.model.ScanRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val attributesToGet: Optional[List[AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToGet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.primitives.AttributeName(item)
          }.toList
        )
    override val limit: Optional[PositiveIntegerObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.PositiveIntegerObject(value)
      )
    override val select: Optional[zio.aws.dynamodb.model.Select] =
      zio.aws.core.internal
        .optionalFromNullable(impl.select())
        .map(value => zio.aws.dynamodb.model.Select.wrap(value))
    override val scanFilter: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanFilter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.Condition.wrap(value)
          })
          .toMap
      )
    override val conditionalOperator
        : Optional[zio.aws.dynamodb.model.ConditionalOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalOperator())
        .map(value => zio.aws.dynamodb.model.ConditionalOperator.wrap(value))
    override val exclusiveStartKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusiveStartKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnConsumedCapacity())
        .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val totalSegments: Optional[ScanTotalSegments] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalSegments())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ScanTotalSegments(value)
        )
    override val segment: Optional[ScanSegment] = zio.aws.core.internal
      .optionalFromNullable(impl.segment())
      .map(value => zio.aws.dynamodb.model.primitives.ScanSegment(value))
    override val projectionExpression: Optional[ProjectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectionExpression())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ProjectionExpression(value)
        )
    override val filterExpression: Optional[ConditionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterExpression())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConditionExpression(value)
        )
    override val expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expressionAttributeNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
                key
              ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
            })
            .toMap
        )
    override val expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val consistentRead: Optional[ConsistentRead] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistentRead())
        .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ScanRequest
  ): zio.aws.dynamodb.model.ScanRequest.ReadOnly = new Wrapper(impl)
}
