package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndexUpdate(
    update: Optional[zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction] =
      Optional.Absent,
    create: Optional[zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction] =
      Optional.Absent,
    delete: Optional[zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate = {
    import GlobalSecondaryIndexUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(create.map(value => value.buildAwsValue()))(_.create)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.wrap(buildAwsValue())
}
object GlobalSecondaryIndexUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate =
      zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate(
        update.map(value => value.asEditable),
        create.map(value => value.asEditable),
        delete.map(value => value.asEditable)
      )
    def update: Optional[
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly
    ]
    def create: Optional[
      zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.ReadOnly
    ]
    def delete: Optional[
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly
    ]
    def getUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly
    ] = AwsError.unwrapOptionField("update", update)
    def getCreate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.ReadOnly
    ] = AwsError.unwrapOptionField("create", create)
    def getDelete: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly
    ] = AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly {
    override val update: Optional[
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.update())
      .map(value =>
        zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.wrap(value)
      )
    override val create: Optional[
      zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.create())
      .map(value =>
        zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.wrap(value)
      )
    override val delete: Optional[
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.delete())
      .map(value =>
        zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly = new Wrapper(
    impl
  )
}
