package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{S3Prefix, S3Bucket, S3BucketOwner}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3BucketSource(
    s3BucketOwner: Optional[S3BucketOwner] = Optional.Absent,
    s3Bucket: S3Bucket,
    s3KeyPrefix: Optional[S3Prefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.S3BucketSource = {
    import S3BucketSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.S3BucketSource
      .builder()
      .optionallyWith(
        s3BucketOwner.map(value =>
          S3BucketOwner.unwrap(value): java.lang.String
        )
      )(_.s3BucketOwner)
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3KeyPrefix.map(value => S3Prefix.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.S3BucketSource.ReadOnly =
    zio.aws.dynamodb.model.S3BucketSource.wrap(buildAwsValue())
}
object S3BucketSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.S3BucketSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.S3BucketSource =
      zio.aws.dynamodb.model.S3BucketSource(
        s3BucketOwner.map(value => value),
        s3Bucket,
        s3KeyPrefix.map(value => value)
      )
    def s3BucketOwner: Optional[S3BucketOwner]
    def s3Bucket: S3Bucket
    def s3KeyPrefix: Optional[S3Prefix]
    def getS3BucketOwner: ZIO[Any, AwsError, S3BucketOwner] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3Prefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.S3BucketSource
  ) extends zio.aws.dynamodb.model.S3BucketSource.ReadOnly {
    override val s3BucketOwner: Optional[S3BucketOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.dynamodb.model.primitives.S3BucketOwner(value))
    override val s3Bucket: S3Bucket =
      zio.aws.dynamodb.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3KeyPrefix: Optional[S3Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => zio.aws.dynamodb.model.primitives.S3Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.S3BucketSource
  ): zio.aws.dynamodb.model.S3BucketSource.ReadOnly = new Wrapper(impl)
}
