package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{CsvHeader, CsvDelimiter}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CsvOptions(
    delimiter: Optional[CsvDelimiter] = Optional.Absent,
    headerList: Optional[Iterable[CsvHeader]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CsvOptions = {
    import CsvOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CsvOptions
      .builder()
      .optionallyWith(
        delimiter.map(value => CsvDelimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(
        headerList.map(value =>
          value.map { item =>
            CsvHeader.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.headerList)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CsvOptions.ReadOnly =
    zio.aws.dynamodb.model.CsvOptions.wrap(buildAwsValue())
}
object CsvOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CsvOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CsvOptions = zio.aws.dynamodb.model
      .CsvOptions(delimiter.map(value => value), headerList.map(value => value))
    def delimiter: Optional[CsvDelimiter]
    def headerList: Optional[List[CsvHeader]]
    def getDelimiter: ZIO[Any, AwsError, CsvDelimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getHeaderList: ZIO[Any, AwsError, List[CsvHeader]] =
      AwsError.unwrapOptionField("headerList", headerList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CsvOptions
  ) extends zio.aws.dynamodb.model.CsvOptions.ReadOnly {
    override val delimiter: Optional[CsvDelimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.dynamodb.model.primitives.CsvDelimiter(value))
    override val headerList: Optional[List[CsvHeader]] = zio.aws.core.internal
      .optionalFromNullable(impl.headerList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.CsvHeader(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CsvOptions
  ): zio.aws.dynamodb.model.CsvOptions.ReadOnly = new Wrapper(impl)
}
