package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait ReturnConsumedCapacity {
  def unwrap
      : software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity
}
object ReturnConsumedCapacity {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity
  ): zio.aws.dynamodb.model.ReturnConsumedCapacity = value match {
    case software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.INDEXES =>
      val r = INDEXES
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.TOTAL =>
      val r = TOTAL
      r
    case software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ReturnConsumedCapacity {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity =
      software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.UNKNOWN_TO_SDK_VERSION
  }
  case object INDEXES extends zio.aws.dynamodb.model.ReturnConsumedCapacity {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity =
      software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.INDEXES
  }
  case object TOTAL extends zio.aws.dynamodb.model.ReturnConsumedCapacity {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity =
      software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.TOTAL
  }
  case object NONE extends zio.aws.dynamodb.model.ReturnConsumedCapacity {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity =
      software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity.NONE
  }
}
