package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{ConsistentRead, PartiQLStatement}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchStatementRequest(
    statement: PartiQLStatement,
    parameters: Optional[Iterable[zio.aws.dynamodb.model.AttributeValue]] =
      Optional.Absent,
    consistentRead: Optional[ConsistentRead] = Optional.Absent,
    returnValuesOnConditionCheckFailure: Optional[
      zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest = {
    import BatchStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest
      .builder()
      .statement(PartiQLStatement.unwrap(statement): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .optionallyWith(
        returnValuesOnConditionCheckFailure.map(value => value.unwrap)
      )(_.returnValuesOnConditionCheckFailure)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchStatementRequest.ReadOnly =
    zio.aws.dynamodb.model.BatchStatementRequest.wrap(buildAwsValue())
}
object BatchStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchStatementRequest =
      zio.aws.dynamodb.model.BatchStatementRequest(
        statement,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consistentRead.map(value => value),
        returnValuesOnConditionCheckFailure.map(value => value)
      )
    def statement: PartiQLStatement
    def parameters
        : Optional[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    def consistentRead: Optional[ConsistentRead]
    def returnValuesOnConditionCheckFailure
        : Optional[zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure]
    def getStatement: ZIO[Any, Nothing, PartiQLStatement] =
      ZIO.succeed(statement)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
    def getReturnValuesOnConditionCheckFailure: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure
    ] = AwsError.unwrapOptionField(
      "returnValuesOnConditionCheckFailure",
      returnValuesOnConditionCheckFailure
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest
  ) extends zio.aws.dynamodb.model.BatchStatementRequest.ReadOnly {
    override val statement: PartiQLStatement =
      zio.aws.dynamodb.model.primitives.PartiQLStatement(impl.statement())
    override val parameters
        : Optional[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.AttributeValue.wrap(item)
          }.toList
        )
    override val consistentRead: Optional[ConsistentRead] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistentRead())
        .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
    override val returnValuesOnConditionCheckFailure
        : Optional[zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnValuesOnConditionCheckFailure())
        .map(value =>
          zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest
  ): zio.aws.dynamodb.model.BatchStatementRequest.ReadOnly = new Wrapper(impl)
}
