package zio.aws.dynamodb
import zio.aws.dynamodb.model.DescribeEndpointsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.dynamodb.{
  DynamoDbAsyncClientBuilder,
  DynamoDbAsyncClient
}
import zio.aws.dynamodb.model.primitives.{TableName, AttributeName}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.dynamodb.paginators.{
  ScanPublisher,
  ListTablesPublisher,
  QueryPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.dynamodb.model.{
  UpdateGlobalTableSettingsRequest,
  ExecuteStatementRequest,
  CreateBackupRequest,
  TransactWriteItemsRequest,
  DescribeImportRequest,
  UpdateTableReplicaAutoScalingRequest,
  DescribeEndpointsRequest,
  ListTagsOfResourceRequest,
  ImportTableRequest,
  PutItemRequest,
  ListImportsRequest,
  DescribeTableRequest,
  ListBackupsRequest,
  RestoreTableFromBackupRequest,
  BatchGetItemRequest,
  CreateGlobalTableRequest,
  GetItemRequest,
  ListContributorInsightsRequest,
  EnableKinesisStreamingDestinationRequest,
  ListExportsRequest,
  UpdateTableRequest,
  DescribeGlobalTableRequest,
  UpdateContributorInsightsRequest,
  DescribeLimitsRequest,
  CreateTableRequest,
  DescribeKinesisStreamingDestinationRequest,
  BatchWriteItemRequest,
  UpdateTimeToLiveRequest,
  ExecuteTransactionRequest,
  DeleteItemRequest,
  DescribeTableReplicaAutoScalingRequest,
  DisableKinesisStreamingDestinationRequest,
  ScanRequest,
  DescribeTimeToLiveRequest,
  QueryRequest,
  UpdateItemRequest,
  DeleteBackupRequest,
  DescribeBackupRequest,
  DescribeGlobalTableSettingsRequest,
  UntagResourceRequest,
  BatchExecuteStatementRequest,
  UpdateContinuousBackupsRequest,
  DescribeContributorInsightsRequest,
  RestoreTableToPointInTimeRequest,
  DeleteTableRequest,
  DescribeContinuousBackupsRequest,
  TransactGetItemsRequest,
  DescribeExportRequest,
  UpdateGlobalTableRequest,
  ListTablesRequest,
  ExportTableToPointInTimeRequest,
  ListGlobalTablesRequest,
  TagResourceRequest
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.dynamodb.model.{
  DescribeBackupResponse,
  ListExportsResponse,
  UpdateTableResponse,
  DescribeExportResponse,
  ScanResponse,
  EnableKinesisStreamingDestinationResponse,
  ExecuteStatementResponse,
  RestoreTableToPointInTimeResponse,
  QueryResponse,
  UpdateGlobalTableResponse,
  TransactGetItemsResponse,
  BatchWriteItemResponse,
  ExecuteTransactionResponse,
  UpdateTimeToLiveResponse,
  DescribeGlobalTableResponse,
  DescribeTableReplicaAutoScalingResponse,
  ContributorInsightsSummary,
  UpdateGlobalTableSettingsResponse,
  ImportTableResponse,
  UpdateTableReplicaAutoScalingResponse,
  Tag,
  TransactWriteItemsResponse,
  ExportTableToPointInTimeResponse,
  ListContributorInsightsResponse,
  DescribeGlobalTableSettingsResponse,
  ListBackupsResponse,
  UntagResourceResponse,
  DescribeLimitsResponse,
  UpdateItemResponse,
  DescribeEndpointsResponse,
  PutItemResponse,
  GetItemResponse,
  ExportSummary,
  ListGlobalTablesResponse,
  CreateGlobalTableResponse,
  DisableKinesisStreamingDestinationResponse,
  DescribeTimeToLiveResponse,
  BatchGetItemResponse,
  CreateBackupResponse,
  DescribeContinuousBackupsResponse,
  ListTagsOfResourceResponse,
  DescribeTableResponse,
  ListTablesResponse,
  DeleteItemResponse,
  ListImportsResponse,
  RestoreTableFromBackupResponse,
  DeleteBackupResponse,
  DescribeKinesisStreamingDestinationResponse,
  DescribeContributorInsightsResponse,
  BatchExecuteStatementResponse,
  DescribeImportResponse,
  UpdateContributorInsightsResponse,
  TagResourceResponse,
  AttributeValue,
  DeleteTableResponse,
  ImportSummary,
  CreateTableResponse,
  UpdateContinuousBackupsResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait DynamoDb extends AspectSupport[DynamoDb] {
  val api: DynamoDbAsyncClient
  def putItem(
      request: PutItemRequest
  ): IO[AwsError, zio.aws.dynamodb.model.PutItemResponse.ReadOnly]
  def restoreTableToPointInTime(request: RestoreTableToPointInTimeRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly
  ]
  def updateGlobalTableSettings(request: UpdateGlobalTableSettingsRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.ReadOnly
  ]
  def batchExecuteStatement(
      request: BatchExecuteStatementRequest
  ): IO[AwsError, zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly]
  def executeTransaction(
      request: ExecuteTransactionRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly]
  def listImports(
      request: ListImportsRequest
  ): ZStream[Any, AwsError, zio.aws.dynamodb.model.ImportSummary.ReadOnly]
  def listImportsPaginated(
      request: ListImportsRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ListImportsResponse.ReadOnly]
  def listBackups(
      request: ListBackupsRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ListBackupsResponse.ReadOnly]
  def updateContributorInsights(request: UpdateContributorInsightsRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.UpdateContributorInsightsResponse.ReadOnly
  ]
  def describeGlobalTable(
      request: DescribeGlobalTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeGlobalTableResponse.ReadOnly]
  def createTable(
      request: CreateTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.CreateTableResponse.ReadOnly]
  def deleteTable(
      request: DeleteTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DeleteTableResponse.ReadOnly]
  def executeStatement(
      request: ExecuteStatementRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly,
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
  ]]
  def executeStatementPaginated(
      request: ExecuteStatementRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly]
  def createBackup(
      request: CreateBackupRequest
  ): IO[AwsError, zio.aws.dynamodb.model.CreateBackupResponse.ReadOnly]
  def enableKinesisStreamingDestination(
      request: EnableKinesisStreamingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly
  ]
  def describeContributorInsights(
      request: DescribeContributorInsightsRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly
  ]
  def listGlobalTables(
      request: ListGlobalTablesRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ListGlobalTablesResponse.ReadOnly]
  def batchGetItem(
      request: BatchGetItemRequest
  ): IO[AwsError, zio.aws.dynamodb.model.BatchGetItemResponse.ReadOnly]
  def describeExport(
      request: DescribeExportRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly]
  def listExports(
      request: ListExportsRequest
  ): ZStream[Any, AwsError, zio.aws.dynamodb.model.ExportSummary.ReadOnly]
  def listExportsPaginated(
      request: ListExportsRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ListExportsResponse.ReadOnly]
  def disableKinesisStreamingDestination(
      request: DisableKinesisStreamingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.ReadOnly
  ]
  def describeGlobalTableSettings(
      request: DescribeGlobalTableSettingsRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.ReadOnly
  ]
  def describeTableReplicaAutoScaling(
      request: DescribeTableReplicaAutoScalingRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.ReadOnly
  ]
  def query(request: QueryRequest): ZStream[Any, AwsError, Map[
    AttributeName,
    zio.aws.dynamodb.model.AttributeValue.ReadOnly
  ]]
  def queryPaginated(
      request: QueryRequest
  ): IO[AwsError, zio.aws.dynamodb.model.QueryResponse.ReadOnly]
  def exportTableToPointInTime(request: ExportTableToPointInTimeRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.ExportTableToPointInTimeResponse.ReadOnly
  ]
  def listTables(request: ListTablesRequest): ZStream[Any, AwsError, TableName]
  def listTablesPaginated(
      request: ListTablesRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ListTablesResponse.ReadOnly]
  def describeTable(
      request: DescribeTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeTableResponse.ReadOnly]
  def restoreTableFromBackup(request: RestoreTableFromBackupRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.RestoreTableFromBackupResponse.ReadOnly
  ]
  def updateContinuousBackups(request: UpdateContinuousBackupsRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.ReadOnly
  ]
  def updateTable(
      request: UpdateTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.UpdateTableResponse.ReadOnly]
  def createGlobalTable(
      request: CreateGlobalTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.CreateGlobalTableResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def listContributorInsights(request: ListContributorInsightsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly
  ]
  def listContributorInsightsPaginated(
      request: ListContributorInsightsRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly
  ]
  def describeImport(
      request: DescribeImportRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeImportResponse.ReadOnly]
  def describeTimeToLive(
      request: DescribeTimeToLiveRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeTimeToLiveResponse.ReadOnly]
  def describeEndpoints(
      request: DescribeEndpointsRequest
  ): IO[AwsError, ReadOnly]
  def transactWriteItems(
      request: TransactWriteItemsRequest
  ): IO[AwsError, zio.aws.dynamodb.model.TransactWriteItemsResponse.ReadOnly]
  def deleteBackup(
      request: DeleteBackupRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DeleteBackupResponse.ReadOnly]
  def describeContinuousBackups(request: DescribeContinuousBackupsRequest): IO[
    AwsError,
    zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def transactGetItems(
      request: TransactGetItemsRequest
  ): IO[AwsError, zio.aws.dynamodb.model.TransactGetItemsResponse.ReadOnly]
  def updateItem(
      request: UpdateItemRequest
  ): IO[AwsError, zio.aws.dynamodb.model.UpdateItemResponse.ReadOnly]
  def updateTableReplicaAutoScaling(
      request: UpdateTableReplicaAutoScalingRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.ReadOnly
  ]
  def getItem(
      request: GetItemRequest
  ): IO[AwsError, zio.aws.dynamodb.model.GetItemResponse.ReadOnly]
  def updateTimeToLive(
      request: UpdateTimeToLiveRequest
  ): IO[AwsError, zio.aws.dynamodb.model.UpdateTimeToLiveResponse.ReadOnly]
  def describeLimits(
      request: DescribeLimitsRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly]
  def updateGlobalTable(
      request: UpdateGlobalTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.UpdateGlobalTableResponse.ReadOnly]
  def batchWriteItem(
      request: BatchWriteItemRequest
  ): IO[AwsError, zio.aws.dynamodb.model.BatchWriteItemResponse.ReadOnly]
  def scan(request: ScanRequest): ZStream[Any, AwsError, Map[
    AttributeName,
    zio.aws.dynamodb.model.AttributeValue.ReadOnly
  ]]
  def scanPaginated(
      request: ScanRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ScanResponse.ReadOnly]
  def listTagsOfResource(
      request: ListTagsOfResourceRequest
  ): ZStream[Any, AwsError, zio.aws.dynamodb.model.Tag.ReadOnly]
  def listTagsOfResourcePaginated(
      request: ListTagsOfResourceRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly]
  def describeBackup(
      request: DescribeBackupRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DescribeBackupResponse.ReadOnly]
  def deleteItem(
      request: DeleteItemRequest
  ): IO[AwsError, zio.aws.dynamodb.model.DeleteItemResponse.ReadOnly]
  def importTable(
      request: ImportTableRequest
  ): IO[AwsError, zio.aws.dynamodb.model.ImportTableResponse.ReadOnly]
  def describeKinesisStreamingDestination(
      request: DescribeKinesisStreamingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.ReadOnly
  ]
}
object DynamoDb {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DynamoDb] = customized(
    identity
  )
  def customized(
      customization: DynamoDbAsyncClientBuilder => DynamoDbAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DynamoDb] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DynamoDbAsyncClientBuilder => DynamoDbAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DynamoDb] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DynamoDbAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[DynamoDbAsyncClient, DynamoDbAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[DynamoDbAsyncClient, DynamoDbAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DynamoDbImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DynamoDbImpl[R](
      override val api: DynamoDbAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DynamoDb
      with AwsServiceBase[R] {
    override val serviceName: String = "DynamoDb"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DynamoDbImpl[R1] = new DynamoDbImpl(api, newAspect, r)
    def putItem(
        request: PutItemRequest
    ): IO[AwsError, zio.aws.dynamodb.model.PutItemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.PutItemRequest,
        PutItemResponse
      ]("putItem", api.putItem)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.PutItemResponse.wrap)
        .provideEnvironment(r)
    def restoreTableToPointInTime(
        request: RestoreTableToPointInTimeRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest,
      RestoreTableToPointInTimeResponse
    ]("restoreTableToPointInTime", api.restoreTableToPointInTime)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.wrap)
      .provideEnvironment(r)
    def updateGlobalTableSettings(
        request: UpdateGlobalTableSettingsRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest,
      UpdateGlobalTableSettingsResponse
    ]("updateGlobalTableSettings", api.updateGlobalTableSettings)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.wrap)
      .provideEnvironment(r)
    def batchExecuteStatement(request: BatchExecuteStatementRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest,
      BatchExecuteStatementResponse
    ]("batchExecuteStatement", api.batchExecuteStatement)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.BatchExecuteStatementResponse.wrap)
      .provideEnvironment(r)
    def executeTransaction(request: ExecuteTransactionRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest,
      ExecuteTransactionResponse
    ]("executeTransaction", api.executeTransaction)(request.buildAwsValue())
      .map(zio.aws.dynamodb.model.ExecuteTransactionResponse.wrap)
      .provideEnvironment(r)
    def listImports(
        request: ListImportsRequest
    ): ZStream[Any, AwsError, zio.aws.dynamodb.model.ImportSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.dynamodb.model.ListImportsRequest,
        ListImportsResponse,
        ImportSummary
      ](
        "listImports",
        api.listImports,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.importSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dynamodb.model.ImportSummary.wrap(item))
        .provideEnvironment(r)
    def listImportsPaginated(
        request: ListImportsRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ListImportsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ListImportsRequest,
        ListImportsResponse
      ]("listImports", api.listImports)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ListImportsResponse.wrap)
        .provideEnvironment(r)
    def listBackups(
        request: ListBackupsRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ListBackupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest,
        ListBackupsResponse
      ]("listBackups", api.listBackups)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ListBackupsResponse.wrap)
        .provideEnvironment(r)
    def updateContributorInsights(
        request: UpdateContributorInsightsRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.UpdateContributorInsightsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest,
      UpdateContributorInsightsResponse
    ]("updateContributorInsights", api.updateContributorInsights)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.UpdateContributorInsightsResponse.wrap)
      .provideEnvironment(r)
    def describeGlobalTable(request: DescribeGlobalTableRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeGlobalTableResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest,
      DescribeGlobalTableResponse
    ]("describeGlobalTable", api.describeGlobalTable)(request.buildAwsValue())
      .map(zio.aws.dynamodb.model.DescribeGlobalTableResponse.wrap)
      .provideEnvironment(r)
    def createTable(
        request: CreateTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.CreateTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.CreateTableRequest,
        CreateTableResponse
      ]("createTable", api.createTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.CreateTableResponse.wrap)
        .provideEnvironment(r)
    def deleteTable(
        request: DeleteTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DeleteTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest,
        DeleteTableResponse
      ]("deleteTable", api.deleteTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DeleteTableResponse.wrap)
        .provideEnvironment(r)
    def executeStatement(
        request: ExecuteStatementRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly,
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest,
      ExecuteStatementResponse,
      java.util.Map[java.lang.String, AttributeValue]
    ](
      "executeStatement",
      api.executeStatement,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.dynamodb.model.ExecuteStatementResponse.wrap)
          .mapOutput(
            _.map(item =>
              item.asScala
                .map({ case (key, value) =>
                  zio.aws.dynamodb.model.primitives.AttributeName(
                    key
                  ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
                })
                .toMap
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def executeStatementPaginated(
        request: ExecuteStatementRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest,
        ExecuteStatementResponse
      ]("executeStatement", api.executeStatement)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ExecuteStatementResponse.wrap)
        .provideEnvironment(r)
    def createBackup(
        request: CreateBackupRequest
    ): IO[AwsError, zio.aws.dynamodb.model.CreateBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest,
        CreateBackupResponse
      ]("createBackup", api.createBackup)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.CreateBackupResponse.wrap)
        .provideEnvironment(r)
    def enableKinesisStreamingDestination(
        request: EnableKinesisStreamingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest,
      EnableKinesisStreamingDestinationResponse
    ](
      "enableKinesisStreamingDestination",
      api.enableKinesisStreamingDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def describeContributorInsights(
        request: DescribeContributorInsightsRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest,
      DescribeContributorInsightsResponse
    ]("describeContributorInsights", api.describeContributorInsights)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.DescribeContributorInsightsResponse.wrap)
      .provideEnvironment(r)
    def listGlobalTables(
        request: ListGlobalTablesRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ListGlobalTablesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest,
        ListGlobalTablesResponse
      ]("listGlobalTables", api.listGlobalTables)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ListGlobalTablesResponse.wrap)
        .provideEnvironment(r)
    def batchGetItem(
        request: BatchGetItemRequest
    ): IO[AwsError, zio.aws.dynamodb.model.BatchGetItemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest,
        BatchGetItemResponse
      ]("batchGetItem", api.batchGetItem)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.BatchGetItemResponse.wrap)
        .provideEnvironment(r)
    def describeExport(
        request: DescribeExportRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest,
        DescribeExportResponse
      ]("describeExport", api.describeExport)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DescribeExportResponse.wrap)
        .provideEnvironment(r)
    def listExports(
        request: ListExportsRequest
    ): ZStream[Any, AwsError, zio.aws.dynamodb.model.ExportSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.dynamodb.model.ListExportsRequest,
        ListExportsResponse,
        ExportSummary
      ](
        "listExports",
        api.listExports,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.exportSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dynamodb.model.ExportSummary.wrap(item))
        .provideEnvironment(r)
    def listExportsPaginated(
        request: ListExportsRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ListExportsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ListExportsRequest,
        ListExportsResponse
      ]("listExports", api.listExports)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ListExportsResponse.wrap)
        .provideEnvironment(r)
    def disableKinesisStreamingDestination(
        request: DisableKinesisStreamingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest,
      DisableKinesisStreamingDestinationResponse
    ](
      "disableKinesisStreamingDestination",
      api.disableKinesisStreamingDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def describeGlobalTableSettings(
        request: DescribeGlobalTableSettingsRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest,
      DescribeGlobalTableSettingsResponse
    ]("describeGlobalTableSettings", api.describeGlobalTableSettings)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.wrap)
      .provideEnvironment(r)
    def describeTableReplicaAutoScaling(
        request: DescribeTableReplicaAutoScalingRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest,
      DescribeTableReplicaAutoScalingResponse
    ]("describeTableReplicaAutoScaling", api.describeTableReplicaAutoScaling)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.wrap)
      .provideEnvironment(r)
    def query(request: QueryRequest): ZStream[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.dynamodb.model.QueryRequest,
      java.util.Map[java.lang.String, AttributeValue],
      QueryPublisher
    ]("query", api.queryPaginator, _.items())(request.buildAwsValue())
      .map(item =>
        item.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
      .provideEnvironment(r)
    def queryPaginated(
        request: QueryRequest
    ): IO[AwsError, zio.aws.dynamodb.model.QueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.QueryRequest,
        QueryResponse
      ]("query", api.query)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.QueryResponse.wrap)
        .provideEnvironment(r)
    def exportTableToPointInTime(request: ExportTableToPointInTimeRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.ExportTableToPointInTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest,
      ExportTableToPointInTimeResponse
    ]("exportTableToPointInTime", api.exportTableToPointInTime)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.ExportTableToPointInTimeResponse.wrap)
      .provideEnvironment(r)
    def listTables(
        request: ListTablesRequest
    ): ZStream[Any, AwsError, TableName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.dynamodb.model.ListTablesRequest,
      java.lang.String,
      ListTablesPublisher
    ]("listTables", api.listTablesPaginator, _.tableNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.dynamodb.model.primitives.TableName(item))
      .provideEnvironment(r)
    def listTablesPaginated(
        request: ListTablesRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ListTablesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ListTablesRequest,
        ListTablesResponse
      ]("listTables", api.listTables)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ListTablesResponse.wrap)
        .provideEnvironment(r)
    def describeTable(
        request: DescribeTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DescribeTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest,
        DescribeTableResponse
      ]("describeTable", api.describeTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DescribeTableResponse.wrap)
        .provideEnvironment(r)
    def restoreTableFromBackup(request: RestoreTableFromBackupRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.RestoreTableFromBackupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest,
      RestoreTableFromBackupResponse
    ]("restoreTableFromBackup", api.restoreTableFromBackup)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.RestoreTableFromBackupResponse.wrap)
      .provideEnvironment(r)
    def updateContinuousBackups(request: UpdateContinuousBackupsRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest,
      UpdateContinuousBackupsResponse
    ]("updateContinuousBackups", api.updateContinuousBackups)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.wrap)
      .provideEnvironment(r)
    def updateTable(
        request: UpdateTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.UpdateTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest,
        UpdateTableResponse
      ]("updateTable", api.updateTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.UpdateTableResponse.wrap)
        .provideEnvironment(r)
    def createGlobalTable(
        request: CreateGlobalTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.CreateGlobalTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest,
        CreateGlobalTableResponse
      ]("createGlobalTable", api.createGlobalTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.CreateGlobalTableResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listContributorInsights(
        request: ListContributorInsightsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest,
      ListContributorInsightsResponse,
      ContributorInsightsSummary
    ](
      "listContributorInsights",
      api.listContributorInsights,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.contributorInsightsSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.dynamodb.model.ContributorInsightsSummary.wrap(item))
      .provideEnvironment(r)
    def listContributorInsightsPaginated(
        request: ListContributorInsightsRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest,
      ListContributorInsightsResponse
    ]("listContributorInsights", api.listContributorInsights)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.ListContributorInsightsResponse.wrap)
      .provideEnvironment(r)
    def describeImport(
        request: DescribeImportRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DescribeImportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest,
        DescribeImportResponse
      ]("describeImport", api.describeImport)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DescribeImportResponse.wrap)
        .provideEnvironment(r)
    def describeTimeToLive(request: DescribeTimeToLiveRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeTimeToLiveResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest,
      DescribeTimeToLiveResponse
    ]("describeTimeToLive", api.describeTimeToLive)(request.buildAwsValue())
      .map(zio.aws.dynamodb.model.DescribeTimeToLiveResponse.wrap)
      .provideEnvironment(r)
    def describeEndpoints(
        request: DescribeEndpointsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest,
      DescribeEndpointsResponse
    ]("describeEndpoints", api.describeEndpoints)(request.buildAwsValue())
      .map(zio.aws.dynamodb.model.DescribeEndpointsResponse.wrap)
      .provideEnvironment(r)
    def transactWriteItems(request: TransactWriteItemsRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.TransactWriteItemsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest,
      TransactWriteItemsResponse
    ]("transactWriteItems", api.transactWriteItems)(request.buildAwsValue())
      .map(zio.aws.dynamodb.model.TransactWriteItemsResponse.wrap)
      .provideEnvironment(r)
    def deleteBackup(
        request: DeleteBackupRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DeleteBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest,
        DeleteBackupResponse
      ]("deleteBackup", api.deleteBackup)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DeleteBackupResponse.wrap)
        .provideEnvironment(r)
    def describeContinuousBackups(
        request: DescribeContinuousBackupsRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest,
      DescribeContinuousBackupsResponse
    ]("describeContinuousBackups", api.describeContinuousBackups)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def transactGetItems(
        request: TransactGetItemsRequest
    ): IO[AwsError, zio.aws.dynamodb.model.TransactGetItemsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest,
        TransactGetItemsResponse
      ]("transactGetItems", api.transactGetItems)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.TransactGetItemsResponse.wrap)
        .provideEnvironment(r)
    def updateItem(
        request: UpdateItemRequest
    ): IO[AwsError, zio.aws.dynamodb.model.UpdateItemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest,
        UpdateItemResponse
      ]("updateItem", api.updateItem)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.UpdateItemResponse.wrap)
        .provideEnvironment(r)
    def updateTableReplicaAutoScaling(
        request: UpdateTableReplicaAutoScalingRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest,
      UpdateTableReplicaAutoScalingResponse
    ]("updateTableReplicaAutoScaling", api.updateTableReplicaAutoScaling)(
      request.buildAwsValue()
    ).map(zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.wrap)
      .provideEnvironment(r)
    def getItem(
        request: GetItemRequest
    ): IO[AwsError, zio.aws.dynamodb.model.GetItemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.GetItemRequest,
        GetItemResponse
      ]("getItem", api.getItem)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.GetItemResponse.wrap)
        .provideEnvironment(r)
    def updateTimeToLive(
        request: UpdateTimeToLiveRequest
    ): IO[AwsError, zio.aws.dynamodb.model.UpdateTimeToLiveResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest,
        UpdateTimeToLiveResponse
      ]("updateTimeToLive", api.updateTimeToLive)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.UpdateTimeToLiveResponse.wrap)
        .provideEnvironment(r)
    def describeLimits(
        request: DescribeLimitsRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest,
        DescribeLimitsResponse
      ]("describeLimits", api.describeLimits)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DescribeLimitsResponse.wrap)
        .provideEnvironment(r)
    def updateGlobalTable(
        request: UpdateGlobalTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.UpdateGlobalTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest,
        UpdateGlobalTableResponse
      ]("updateGlobalTable", api.updateGlobalTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.UpdateGlobalTableResponse.wrap)
        .provideEnvironment(r)
    def batchWriteItem(
        request: BatchWriteItemRequest
    ): IO[AwsError, zio.aws.dynamodb.model.BatchWriteItemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest,
        BatchWriteItemResponse
      ]("batchWriteItem", api.batchWriteItem)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.BatchWriteItemResponse.wrap)
        .provideEnvironment(r)
    def scan(request: ScanRequest): ZStream[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.dynamodb.model.ScanRequest,
      java.util.Map[java.lang.String, AttributeValue],
      ScanPublisher
    ]("scan", api.scanPaginator, _.items())(request.buildAwsValue())
      .map(item =>
        item.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
      .provideEnvironment(r)
    def scanPaginated(
        request: ScanRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ScanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ScanRequest,
        ScanResponse
      ]("scan", api.scan)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ScanResponse.wrap)
        .provideEnvironment(r)
    def listTagsOfResource(request: ListTagsOfResourceRequest): ZStream[
      Any,
      AwsError,
      zio.aws.dynamodb.model.Tag.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest,
      ListTagsOfResourceResponse,
      Tag
    ](
      "listTagsOfResource",
      api.listTagsOfResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.dynamodb.model.Tag.wrap(item))
      .provideEnvironment(r)
    def listTagsOfResourcePaginated(request: ListTagsOfResourceRequest): IO[
      AwsError,
      zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest,
      ListTagsOfResourceResponse
    ]("listTagsOfResource", api.listTagsOfResource)(request.buildAwsValue())
      .map(zio.aws.dynamodb.model.ListTagsOfResourceResponse.wrap)
      .provideEnvironment(r)
    def describeBackup(
        request: DescribeBackupRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DescribeBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest,
        DescribeBackupResponse
      ]("describeBackup", api.describeBackup)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DescribeBackupResponse.wrap)
        .provideEnvironment(r)
    def deleteItem(
        request: DeleteItemRequest
    ): IO[AwsError, zio.aws.dynamodb.model.DeleteItemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest,
        DeleteItemResponse
      ]("deleteItem", api.deleteItem)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.DeleteItemResponse.wrap)
        .provideEnvironment(r)
    def importTable(
        request: ImportTableRequest
    ): IO[AwsError, zio.aws.dynamodb.model.ImportTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ImportTableRequest,
        ImportTableResponse
      ]("importTable", api.importTable)(request.buildAwsValue())
        .map(zio.aws.dynamodb.model.ImportTableResponse.wrap)
        .provideEnvironment(r)
    def describeKinesisStreamingDestination(
        request: DescribeKinesisStreamingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest,
      DescribeKinesisStreamingDestinationResponse
    ](
      "describeKinesisStreamingDestination",
      api.describeKinesisStreamingDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def putItem(request: PutItemRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.PutItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putItem(request))
  def restoreTableToPointInTime(request: RestoreTableToPointInTimeRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreTableToPointInTime(request))
  def updateGlobalTableSettings(request: UpdateGlobalTableSettingsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateGlobalTableSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGlobalTableSettings(request))
  def batchExecuteStatement(request: BatchExecuteStatementRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchExecuteStatement(request))
  def executeTransaction(request: ExecuteTransactionRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeTransaction(request))
  def listImports(request: ListImportsRequest): ZStream[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ImportSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImports(request))
  def listImportsPaginated(request: ListImportsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListImportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImportsPaginated(request))
  def listBackups(request: ListBackupsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackups(request))
  def updateContributorInsights(request: UpdateContributorInsightsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateContributorInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContributorInsights(request))
  def describeGlobalTable(request: DescribeGlobalTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeGlobalTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalTable(request))
  def createTable(request: CreateTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.CreateTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTable(request))
  def deleteTable(request: DeleteTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DeleteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTable(request))
  def executeStatement(
      request: ExecuteStatementRequest
  ): ZIO[zio.aws.dynamodb.DynamoDb, AwsError, StreamingOutputResult[
    Any,
    zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly,
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
  ]] = ZIO.serviceWithZIO(_.executeStatement(request))
  def executeStatementPaginated(request: ExecuteStatementRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeStatementPaginated(request))
  def createBackup(request: CreateBackupRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.CreateBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackup(request))
  def enableKinesisStreamingDestination(
      request: EnableKinesisStreamingDestinationRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableKinesisStreamingDestination(request))
  def describeContributorInsights(
      request: DescribeContributorInsightsRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContributorInsights(request))
  def listGlobalTables(request: ListGlobalTablesRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListGlobalTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGlobalTables(request))
  def batchGetItem(request: BatchGetItemRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.BatchGetItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetItem(request))
  def describeExport(request: DescribeExportRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExport(request))
  def listExports(request: ListExportsRequest): ZStream[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ExportSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listExports(request))
  def listExportsPaginated(request: ListExportsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListExportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExportsPaginated(request))
  def disableKinesisStreamingDestination(
      request: DisableKinesisStreamingDestinationRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableKinesisStreamingDestination(request))
  def describeGlobalTableSettings(
      request: DescribeGlobalTableSettingsRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalTableSettings(request))
  def describeTableReplicaAutoScaling(
      request: DescribeTableReplicaAutoScalingRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTableReplicaAutoScaling(request))
  def query(
      request: QueryRequest
  ): ZStream[zio.aws.dynamodb.DynamoDb, AwsError, Map[
    AttributeName,
    zio.aws.dynamodb.model.AttributeValue.ReadOnly
  ]] = ZStream.serviceWithStream(_.query(request))
  def queryPaginated(request: QueryRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.QueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.queryPaginated(request))
  def exportTableToPointInTime(request: ExportTableToPointInTimeRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ExportTableToPointInTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportTableToPointInTime(request))
  def listTables(
      request: ListTablesRequest
  ): ZStream[zio.aws.dynamodb.DynamoDb, AwsError, TableName] =
    ZStream.serviceWithStream(_.listTables(request))
  def listTablesPaginated(request: ListTablesRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTablesPaginated(request))
  def describeTable(request: DescribeTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTable(request))
  def restoreTableFromBackup(request: RestoreTableFromBackupRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.RestoreTableFromBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreTableFromBackup(request))
  def updateContinuousBackups(request: UpdateContinuousBackupsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateContinuousBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContinuousBackups(request))
  def updateTable(request: UpdateTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTable(request))
  def createGlobalTable(request: CreateGlobalTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.CreateGlobalTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlobalTable(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.dynamodb.DynamoDb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def listContributorInsights(request: ListContributorInsightsRequest): ZStream[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContributorInsights(request))
  def listContributorInsightsPaginated(
      request: ListContributorInsightsRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContributorInsightsPaginated(request))
  def describeImport(request: DescribeImportRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImport(request))
  def describeTimeToLive(request: DescribeTimeToLiveRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeTimeToLiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTimeToLive(request))
  def describeEndpoints(
      request: DescribeEndpointsRequest
  ): ZIO[zio.aws.dynamodb.DynamoDb, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeEndpoints(request))
  def transactWriteItems(request: TransactWriteItemsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.TransactWriteItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.transactWriteItems(request))
  def deleteBackup(request: DeleteBackupRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DeleteBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackup(request))
  def describeContinuousBackups(request: DescribeContinuousBackupsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContinuousBackups(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.dynamodb.DynamoDb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def transactGetItems(request: TransactGetItemsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.TransactGetItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.transactGetItems(request))
  def updateItem(request: UpdateItemRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateItem(request))
  def updateTableReplicaAutoScaling(
      request: UpdateTableReplicaAutoScalingRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTableReplicaAutoScaling(request))
  def getItem(request: GetItemRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.GetItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getItem(request))
  def updateTimeToLive(request: UpdateTimeToLiveRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateTimeToLiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTimeToLive(request))
  def describeLimits(request: DescribeLimitsRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLimits(request))
  def updateGlobalTable(request: UpdateGlobalTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.UpdateGlobalTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGlobalTable(request))
  def batchWriteItem(request: BatchWriteItemRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.BatchWriteItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchWriteItem(request))
  def scan(
      request: ScanRequest
  ): ZStream[zio.aws.dynamodb.DynamoDb, AwsError, Map[
    AttributeName,
    zio.aws.dynamodb.model.AttributeValue.ReadOnly
  ]] = ZStream.serviceWithStream(_.scan(request))
  def scanPaginated(request: ScanRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ScanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.scanPaginated(request))
  def listTagsOfResource(request: ListTagsOfResourceRequest): ZStream[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsOfResource(request))
  def listTagsOfResourcePaginated(request: ListTagsOfResourceRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsOfResourcePaginated(request))
  def describeBackup(request: DescribeBackupRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackup(request))
  def deleteItem(request: DeleteItemRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DeleteItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteItem(request))
  def importTable(request: ImportTableRequest): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.ImportTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importTable(request))
  def describeKinesisStreamingDestination(
      request: DescribeKinesisStreamingDestinationRequest
  ): ZIO[
    zio.aws.dynamodb.DynamoDb,
    AwsError,
    zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKinesisStreamingDestination(request))
}
