package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndex(
    indexName: IndexName,
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    projection: zio.aws.dynamodb.model.Projection,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex = {
    import GlobalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .projection(projection.buildAwsValue())
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(buildAwsValue())
}
object GlobalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndex =
      zio.aws.dynamodb.model.GlobalSecondaryIndex(
        indexName,
        keySchema.map { item =>
          item.asEditable
        },
        projection.asEditable,
        provisionedThroughput.map(value => value.asEditable)
      )
    def indexName: IndexName
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def projection: zio.aws.dynamodb.model.Projection.ReadOnly
    def provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getProjection
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.Projection.ReadOnly] =
      ZIO.succeed(projection)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val projection: zio.aws.dynamodb.model.Projection.ReadOnly =
      zio.aws.dynamodb.model.Projection.wrap(impl.projection())
    override val provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
  ): zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly = new Wrapper(impl)
}
