package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait TimeToLiveStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus
}
object TimeToLiveStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus
  ): zio.aws.dynamodb.model.TimeToLiveStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus =
      software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLING extends zio.aws.dynamodb.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus =
      software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.ENABLING
  }
  case object DISABLING extends zio.aws.dynamodb.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus =
      software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.DISABLING
  }
  case object ENABLED extends zio.aws.dynamodb.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus =
      software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.ENABLED
  }
  case object DISABLED extends zio.aws.dynamodb.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus =
      software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus.DISABLED
  }
}
