package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{StreamArn, TableId, Date, TableName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TableDescription(
    attributeDefinitions: Optional[
      Iterable[zio.aws.dynamodb.model.AttributeDefinition]
    ] = Optional.Absent,
    tableName: Optional[TableName] = Optional.Absent,
    keySchema: Optional[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] =
      Optional.Absent,
    tableStatus: Optional[zio.aws.dynamodb.model.TableStatus] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription
    ] = Optional.Absent,
    tableSizeBytes: Optional[Long] = Optional.Absent,
    itemCount: Optional[Long] = Optional.Absent,
    tableArn: Optional[String] = Optional.Absent,
    tableId: Optional[TableId] = Optional.Absent,
    billingModeSummary: Optional[zio.aws.dynamodb.model.BillingModeSummary] =
      Optional.Absent,
    localSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndexDescription]
    ] = Optional.Absent,
    globalSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription]
    ] = Optional.Absent,
    streamSpecification: Optional[zio.aws.dynamodb.model.StreamSpecification] =
      Optional.Absent,
    latestStreamLabel: Optional[String] = Optional.Absent,
    latestStreamArn: Optional[StreamArn] = Optional.Absent,
    globalTableVersion: Optional[String] = Optional.Absent,
    replicas: Optional[Iterable[zio.aws.dynamodb.model.ReplicaDescription]] =
      Optional.Absent,
    restoreSummary: Optional[zio.aws.dynamodb.model.RestoreSummary] =
      Optional.Absent,
    sseDescription: Optional[zio.aws.dynamodb.model.SSEDescription] =
      Optional.Absent,
    archivalSummary: Optional[zio.aws.dynamodb.model.ArchivalSummary] =
      Optional.Absent,
    tableClassSummary: Optional[zio.aws.dynamodb.model.TableClassSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableDescription = {
    import TableDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableDescription
      .builder()
      .optionallyWith(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeDefinitions)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(tableStatus.map(value => value.unwrap))(_.tableStatus)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(tableSizeBytes.map(value => value: java.lang.Long))(
        _.tableSizeBytes
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Long))(
        _.itemCount
      )
      .optionallyWith(tableArn.map(value => value: java.lang.String))(
        _.tableArn
      )
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(billingModeSummary.map(value => value.buildAwsValue()))(
        _.billingModeSummary
      )
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(latestStreamLabel.map(value => value: java.lang.String))(
        _.latestStreamLabel
      )
      .optionallyWith(
        latestStreamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.latestStreamArn)
      .optionallyWith(globalTableVersion.map(value => value: java.lang.String))(
        _.globalTableVersion
      )
      .optionallyWith(
        replicas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicas)
      .optionallyWith(restoreSummary.map(value => value.buildAwsValue()))(
        _.restoreSummary
      )
      .optionallyWith(sseDescription.map(value => value.buildAwsValue()))(
        _.sseDescription
      )
      .optionallyWith(archivalSummary.map(value => value.buildAwsValue()))(
        _.archivalSummary
      )
      .optionallyWith(tableClassSummary.map(value => value.buildAwsValue()))(
        _.tableClassSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableDescription.ReadOnly =
    zio.aws.dynamodb.model.TableDescription.wrap(buildAwsValue())
}
object TableDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableDescription =
      zio.aws.dynamodb.model.TableDescription(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableStatus.map(value => value),
        creationDateTime.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        tableSizeBytes.map(value => value),
        itemCount.map(value => value),
        tableArn.map(value => value),
        tableId.map(value => value),
        billingModeSummary.map(value => value.asEditable),
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamSpecification.map(value => value.asEditable),
        latestStreamLabel.map(value => value),
        latestStreamArn.map(value => value),
        globalTableVersion.map(value => value),
        replicas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restoreSummary.map(value => value.asEditable),
        sseDescription.map(value => value.asEditable),
        archivalSummary.map(value => value.asEditable),
        tableClassSummary.map(value => value.asEditable)
      )
    def attributeDefinitions
        : Optional[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]]
    def tableName: Optional[TableName]
    def keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def tableStatus: Optional[zio.aws.dynamodb.model.TableStatus]
    def creationDateTime: Optional[Date]
    def provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ]
    def tableSizeBytes: Optional[Long]
    def itemCount: Optional[Long]
    def tableArn: Optional[String]
    def tableId: Optional[TableId]
    def billingModeSummary
        : Optional[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly]
    def localSecondaryIndexes: Optional[
      List[zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly]
    ]
    def globalSecondaryIndexes: Optional[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly]
    ]
    def streamSpecification
        : Optional[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def latestStreamLabel: Optional[String]
    def latestStreamArn: Optional[StreamArn]
    def globalTableVersion: Optional[String]
    def replicas
        : Optional[List[zio.aws.dynamodb.model.ReplicaDescription.ReadOnly]]
    def restoreSummary: Optional[zio.aws.dynamodb.model.RestoreSummary.ReadOnly]
    def sseDescription: Optional[zio.aws.dynamodb.model.SSEDescription.ReadOnly]
    def archivalSummary
        : Optional[zio.aws.dynamodb.model.ArchivalSummary.ReadOnly]
    def tableClassSummary
        : Optional[zio.aws.dynamodb.model.TableClassSummary.ReadOnly]
    def getAttributeDefinitions: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("attributeDefinitions", attributeDefinitions)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getTableStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableStatus] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getTableSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("tableSizeBytes", tableSizeBytes)
    def getItemCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getTableArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getBillingModeSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BillingModeSummary.ReadOnly
    ] = AwsError.unwrapOptionField("billingModeSummary", billingModeSummary)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getLatestStreamLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("latestStreamLabel", latestStreamLabel)
    def getLatestStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("latestStreamArn", latestStreamArn)
    def getGlobalTableVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalTableVersion", globalTableVersion)
    def getReplicas: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicas", replicas)
    def getRestoreSummary
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.RestoreSummary.ReadOnly] =
      AwsError.unwrapOptionField("restoreSummary", restoreSummary)
    def getSseDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSEDescription.ReadOnly] =
      AwsError.unwrapOptionField("sseDescription", sseDescription)
    def getArchivalSummary
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ArchivalSummary.ReadOnly] =
      AwsError.unwrapOptionField("archivalSummary", archivalSummary)
    def getTableClassSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableClassSummary.ReadOnly
    ] = AwsError.unwrapOptionField("tableClassSummary", tableClassSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableDescription
  ) extends zio.aws.dynamodb.model.TableDescription.ReadOnly {
    override val attributeDefinitions
        : Optional[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
          }.toList
        )
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySchema())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
          }.toList
        )
    override val tableStatus: Optional[zio.aws.dynamodb.model.TableStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableStatus())
        .map(value => zio.aws.dynamodb.model.TableStatus.wrap(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughput())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputDescription.wrap(value)
      )
    override val tableSizeBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.tableSizeBytes())
      .map(value => value: Long)
    override val itemCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Long)
    override val tableArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => value: String)
    override val tableId: Optional[TableId] = zio.aws.core.internal
      .optionalFromNullable(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val billingModeSummary
        : Optional[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingModeSummary())
        .map(value => zio.aws.dynamodb.model.BillingModeSummary.wrap(value))
    override val localSecondaryIndexes: Optional[
      List[zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.localSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.LocalSecondaryIndexDescription.wrap(item)
        }.toList
      )
    override val globalSecondaryIndexes: Optional[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.wrap(item)
        }.toList
      )
    override val streamSpecification
        : Optional[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSpecification())
        .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val latestStreamLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.latestStreamLabel())
      .map(value => value: String)
    override val latestStreamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.latestStreamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val globalTableVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.globalTableVersion())
      .map(value => value: String)
    override val replicas
        : Optional[List[zio.aws.dynamodb.model.ReplicaDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ReplicaDescription.wrap(item)
          }.toList
        )
    override val restoreSummary
        : Optional[zio.aws.dynamodb.model.RestoreSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreSummary())
        .map(value => zio.aws.dynamodb.model.RestoreSummary.wrap(value))
    override val sseDescription
        : Optional[zio.aws.dynamodb.model.SSEDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseDescription())
        .map(value => zio.aws.dynamodb.model.SSEDescription.wrap(value))
    override val archivalSummary
        : Optional[zio.aws.dynamodb.model.ArchivalSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archivalSummary())
        .map(value => zio.aws.dynamodb.model.ArchivalSummary.wrap(value))
    override val tableClassSummary
        : Optional[zio.aws.dynamodb.model.TableClassSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableClassSummary())
        .map(value => zio.aws.dynamodb.model.TableClassSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableDescription
  ): zio.aws.dynamodb.model.TableDescription.ReadOnly = new Wrapper(impl)
}
