package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTableReplicaAutoScalingResponse(
    tableAutoScalingDescription: Optional[
      zio.aws.dynamodb.model.TableAutoScalingDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse = {
    import DescribeTableReplicaAutoScalingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse
      .builder()
      .optionallyWith(
        tableAutoScalingDescription.map(value => value.buildAwsValue())
      )(_.tableAutoScalingDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse
      .wrap(buildAwsValue())
}
object DescribeTableReplicaAutoScalingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse =
      zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse(
        tableAutoScalingDescription.map(value => value.asEditable)
      )
    def tableAutoScalingDescription
        : Optional[zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly]
    def getTableAutoScalingDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tableAutoScalingDescription",
      tableAutoScalingDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse
  ) extends zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.ReadOnly {
    override val tableAutoScalingDescription: Optional[
      zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tableAutoScalingDescription())
      .map(value =>
        zio.aws.dynamodb.model.TableAutoScalingDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse
  ): zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingResponse.ReadOnly =
    new Wrapper(impl)
}
