package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class DescribeKinesisStreamingDestinationRequest(
    tableName: TableName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest = {
    import DescribeKinesisStreamingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationRequest
      .wrap(buildAwsValue())
}
object DescribeKinesisStreamingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationRequest =
      zio.aws.dynamodb.model
        .DescribeKinesisStreamingDestinationRequest(tableName)
    def tableName: TableName
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest
  ) extends zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest
  ): zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
