package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait AttributeAction {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.AttributeAction
}
object AttributeAction {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.AttributeAction
  ): zio.aws.dynamodb.model.AttributeAction = value match {
    case software.amazon.awssdk.services.dynamodb.model.AttributeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.AttributeAction.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.dynamodb.model.AttributeAction.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.dynamodb.model.AttributeAction.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.AttributeAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.AttributeAction =
      software.amazon.awssdk.services.dynamodb.model.AttributeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.dynamodb.model.AttributeAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.AttributeAction =
      software.amazon.awssdk.services.dynamodb.model.AttributeAction.ADD
  }
  case object PUT extends zio.aws.dynamodb.model.AttributeAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.AttributeAction =
      software.amazon.awssdk.services.dynamodb.model.AttributeAction.PUT
  }
  case object DELETE extends zio.aws.dynamodb.model.AttributeAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.AttributeAction =
      software.amazon.awssdk.services.dynamodb.model.AttributeAction.DELETE
  }
}
