package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait InputFormat {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.InputFormat
}
object InputFormat {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.InputFormat
  ): zio.aws.dynamodb.model.InputFormat = value match {
    case software.amazon.awssdk.services.dynamodb.model.InputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.InputFormat.DYNAMODB_JSON =>
      val r = DYNAMODB_JSON
      r
    case software.amazon.awssdk.services.dynamodb.model.InputFormat.ION =>
      val r = ION
      r
    case software.amazon.awssdk.services.dynamodb.model.InputFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputFormat =
      software.amazon.awssdk.services.dynamodb.model.InputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object DYNAMODB_JSON extends zio.aws.dynamodb.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputFormat =
      software.amazon.awssdk.services.dynamodb.model.InputFormat.DYNAMODB_JSON
  }
  case object ION extends zio.aws.dynamodb.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputFormat =
      software.amazon.awssdk.services.dynamodb.model.InputFormat.ION
  }
  case object CSV extends zio.aws.dynamodb.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.InputFormat =
      software.amazon.awssdk.services.dynamodb.model.InputFormat.CSV
  }
}
