package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PartiQLNextToken, AttributeName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementResponse(
    items: Optional[
      Iterable[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
    ] = Optional.Absent,
    nextToken: Optional[PartiQLNextToken] = Optional.Absent,
    consumedCapacity: Optional[zio.aws.dynamodb.model.ConsumedCapacity] =
      Optional.Absent,
    lastEvaluatedKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse = {
    import ExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> value
                  .buildAwsValue()
              })
              .asJava
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PartiQLNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(consumedCapacity.map(value => value.buildAwsValue()))(
        _.consumedCapacity
      )
      .optionallyWith(
        lastEvaluatedKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.lastEvaluatedKey)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly =
    zio.aws.dynamodb.model.ExecuteStatementResponse.wrap(buildAwsValue())
}
object ExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExecuteStatementResponse =
      zio.aws.dynamodb.model.ExecuteStatementResponse(
        items.map(value =>
          value.map { item =>
            item.map({ case (key, value) =>
              key -> value.asEditable
            })
          }
        ),
        nextToken.map(value => value),
        consumedCapacity.map(value => value.asEditable),
        lastEvaluatedKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def items: Optional[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ]
    def nextToken: Optional[PartiQLNextToken]
    def consumedCapacity
        : Optional[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]
    def lastEvaluatedKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def getItems: ZIO[Any, AwsError, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PartiQLNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
    def getLastEvaluatedKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("lastEvaluatedKey", lastEvaluatedKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
  ) extends zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly {
    override val items: Optional[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.AttributeName(
                key
              ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
            })
            .toMap
        }.toList
      )
    override val nextToken: Optional[PartiQLNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.PartiQLNextToken(value))
    override val consumedCapacity
        : Optional[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value => zio.aws.dynamodb.model.ConsumedCapacity.wrap(value))
    override val lastEvaluatedKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lastEvaluatedKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
  ): zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly = new Wrapper(
    impl
  )
}
