package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeExportResponse(
    exportDescription: Optional[zio.aws.dynamodb.model.ExportDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse = {
    import DescribeExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
      .builder()
      .optionallyWith(exportDescription.map(value => value.buildAwsValue()))(
        _.exportDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeExportResponse.wrap(buildAwsValue())
}
object DescribeExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeExportResponse =
      zio.aws.dynamodb.model.DescribeExportResponse(
        exportDescription.map(value => value.asEditable)
      )
    def exportDescription
        : Optional[zio.aws.dynamodb.model.ExportDescription.ReadOnly]
    def getExportDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ExportDescription.ReadOnly
    ] = AwsError.unwrapOptionField("exportDescription", exportDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
  ) extends zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly {
    override val exportDescription
        : Optional[zio.aws.dynamodb.model.ExportDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportDescription())
        .map(value => zio.aws.dynamodb.model.ExportDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
  ): zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly = new Wrapper(impl)
}
