package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LocalSecondaryIndexDescription(
    indexName: Optional[IndexName] = Optional.Absent,
    keySchema: Optional[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] =
      Optional.Absent,
    projection: Optional[zio.aws.dynamodb.model.Projection] = Optional.Absent,
    indexSizeBytes: Optional[Long] = Optional.Absent,
    itemCount: Optional[Long] = Optional.Absent,
    indexArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription = {
    import LocalSecondaryIndexDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .optionallyWith(indexSizeBytes.map(value => value: java.lang.Long))(
        _.indexSizeBytes
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Long))(
        _.itemCount
      )
      .optionallyWith(indexArn.map(value => value: java.lang.String))(
        _.indexArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly =
    zio.aws.dynamodb.model.LocalSecondaryIndexDescription.wrap(buildAwsValue())
}
object LocalSecondaryIndexDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.LocalSecondaryIndexDescription =
      zio.aws.dynamodb.model.LocalSecondaryIndexDescription(
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable),
        indexSizeBytes.map(value => value),
        itemCount.map(value => value),
        indexArn.map(value => value)
      )
    def indexName: Optional[IndexName]
    def keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def projection: Optional[zio.aws.dynamodb.model.Projection.ReadOnly]
    def indexSizeBytes: Optional[Long]
    def itemCount: Optional[Long]
    def indexArn: Optional[String]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.Projection.ReadOnly] =
      AwsError.unwrapOptionField("projection", projection)
    def getIndexSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("indexSizeBytes", indexSizeBytes)
    def getItemCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getIndexArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("indexArn", indexArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
  ) extends zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySchema())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
          }.toList
        )
    override val projection
        : Optional[zio.aws.dynamodb.model.Projection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projection())
        .map(value => zio.aws.dynamodb.model.Projection.wrap(value))
    override val indexSizeBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.indexSizeBytes())
      .map(value => value: Long)
    override val itemCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Long)
    override val indexArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.indexArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
  ): zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly =
    new Wrapper(impl)
}
