package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PointInTimeRecoveryDescription(
    pointInTimeRecoveryStatus: Optional[
      zio.aws.dynamodb.model.PointInTimeRecoveryStatus
    ] = Optional.Absent,
    earliestRestorableDateTime: Optional[Date] = Optional.Absent,
    latestRestorableDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription = {
    import PointInTimeRecoveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
      .builder()
      .optionallyWith(pointInTimeRecoveryStatus.map(value => value.unwrap))(
        _.pointInTimeRecoveryStatus
      )
      .optionallyWith(
        earliestRestorableDateTime.map(value => Date.unwrap(value): Instant)
      )(_.earliestRestorableDateTime)
      .optionallyWith(
        latestRestorableDateTime.map(value => Date.unwrap(value): Instant)
      )(_.latestRestorableDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly =
    zio.aws.dynamodb.model.PointInTimeRecoveryDescription.wrap(buildAwsValue())
}
object PointInTimeRecoveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PointInTimeRecoveryDescription =
      zio.aws.dynamodb.model.PointInTimeRecoveryDescription(
        pointInTimeRecoveryStatus.map(value => value),
        earliestRestorableDateTime.map(value => value),
        latestRestorableDateTime.map(value => value)
      )
    def pointInTimeRecoveryStatus
        : Optional[zio.aws.dynamodb.model.PointInTimeRecoveryStatus]
    def earliestRestorableDateTime: Optional[Date]
    def latestRestorableDateTime: Optional[Date]
    def getPointInTimeRecoveryStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.PointInTimeRecoveryStatus] =
      AwsError.unwrapOptionField(
        "pointInTimeRecoveryStatus",
        pointInTimeRecoveryStatus
      )
    def getEarliestRestorableDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "earliestRestorableDateTime",
        earliestRestorableDateTime
      )
    def getLatestRestorableDateTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("latestRestorableDateTime", latestRestorableDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
  ) extends zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly {
    override val pointInTimeRecoveryStatus
        : Optional[zio.aws.dynamodb.model.PointInTimeRecoveryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pointInTimeRecoveryStatus())
        .map(value =>
          zio.aws.dynamodb.model.PointInTimeRecoveryStatus.wrap(value)
        )
    override val earliestRestorableDateTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.earliestRestorableDateTime())
        .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val latestRestorableDateTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestRestorableDateTime())
        .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
  ): zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly =
    new Wrapper(impl)
}
