package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ClientRequestToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TransactWriteItemsRequest(
    transactItems: Iterable[zio.aws.dynamodb.model.TransactWriteItem],
    returnConsumedCapacity: Optional[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = Optional.Absent,
    returnItemCollectionMetrics: Optional[
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest = {
    import TransactWriteItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest
      .builder()
      .transactItems(transactItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(returnItemCollectionMetrics.map(value => value.unwrap))(
        _.returnItemCollectionMetrics
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactWriteItemsRequest.ReadOnly =
    zio.aws.dynamodb.model.TransactWriteItemsRequest.wrap(buildAwsValue())
}
object TransactWriteItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactWriteItemsRequest =
      zio.aws.dynamodb.model.TransactWriteItemsRequest(
        transactItems.map { item =>
          item.asEditable
        },
        returnConsumedCapacity.map(value => value),
        returnItemCollectionMetrics.map(value => value),
        clientRequestToken.map(value => value)
      )
    def transactItems: List[zio.aws.dynamodb.model.TransactWriteItem.ReadOnly]
    def returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def returnItemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ReturnItemCollectionMetrics]
    def clientRequestToken: Optional[ClientRequestToken]
    def getTransactItems: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.TransactWriteItem.ReadOnly
    ]] = ZIO.succeed(transactItems)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getReturnItemCollectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = AwsError.unwrapOptionField(
      "returnItemCollectionMetrics",
      returnItemCollectionMetrics
    )
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest
  ) extends zio.aws.dynamodb.model.TransactWriteItemsRequest.ReadOnly {
    override val transactItems
        : List[zio.aws.dynamodb.model.TransactWriteItem.ReadOnly] = impl
      .transactItems()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.TransactWriteItem.wrap(item)
      }
      .toList
    override val returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnConsumedCapacity())
        .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val returnItemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ReturnItemCollectionMetrics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnItemCollectionMetrics())
        .map(value =>
          zio.aws.dynamodb.model.ReturnItemCollectionMetrics.wrap(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest
  ): zio.aws.dynamodb.model.TransactWriteItemsRequest.ReadOnly = new Wrapper(
    impl
  )
}
