package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeImportResponse(
    importTableDescription: zio.aws.dynamodb.model.ImportTableDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse = {
    import DescribeImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse
      .builder()
      .importTableDescription(importTableDescription.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeImportResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeImportResponse.wrap(buildAwsValue())
}
object DescribeImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeImportResponse =
      zio.aws.dynamodb.model
        .DescribeImportResponse(importTableDescription.asEditable)
    def importTableDescription
        : zio.aws.dynamodb.model.ImportTableDescription.ReadOnly
    def getImportTableDescription: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.ImportTableDescription.ReadOnly
    ] = ZIO.succeed(importTableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse
  ) extends zio.aws.dynamodb.model.DescribeImportResponse.ReadOnly {
    override val importTableDescription
        : zio.aws.dynamodb.model.ImportTableDescription.ReadOnly =
      zio.aws.dynamodb.model.ImportTableDescription
        .wrap(impl.importTableDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse
  ): zio.aws.dynamodb.model.DescribeImportResponse.ReadOnly = new Wrapper(impl)
}
