package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class UpdateTimeToLiveRequest(
    tableName: TableName,
    timeToLiveSpecification: zio.aws.dynamodb.model.TimeToLiveSpecification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest = {
    import UpdateTimeToLiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .timeToLiveSpecification(timeToLiveSpecification.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateTimeToLiveRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateTimeToLiveRequest.wrap(buildAwsValue())
}
object UpdateTimeToLiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateTimeToLiveRequest =
      zio.aws.dynamodb.model
        .UpdateTimeToLiveRequest(tableName, timeToLiveSpecification.asEditable)
    def tableName: TableName
    def timeToLiveSpecification
        : zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getTimeToLiveSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly
    ] = ZIO.succeed(timeToLiveSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest
  ) extends zio.aws.dynamodb.model.UpdateTimeToLiveRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val timeToLiveSpecification
        : zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly =
      zio.aws.dynamodb.model.TimeToLiveSpecification
        .wrap(impl.timeToLiveSpecification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest
  ): zio.aws.dynamodb.model.UpdateTimeToLiveRequest.ReadOnly = new Wrapper(impl)
}
