package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  TableName,
  AttributeName,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ExpressionAttributeValueVariable,
  UpdateExpression
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateItemRequest(
    tableName: TableName,
    key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue],
    attributeUpdates: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValueUpdate]
    ] = Optional.Absent,
    expected: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue]
    ] = Optional.Absent,
    conditionalOperator: Optional[zio.aws.dynamodb.model.ConditionalOperator] =
      Optional.Absent,
    returnValues: Optional[zio.aws.dynamodb.model.ReturnValue] =
      Optional.Absent,
    returnConsumedCapacity: Optional[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = Optional.Absent,
    returnItemCollectionMetrics: Optional[
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = Optional.Absent,
    updateExpression: Optional[UpdateExpression] = Optional.Absent,
    conditionExpression: Optional[ConditionExpression] = Optional.Absent,
    expressionAttributeNames: Optional[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = Optional.Absent,
    expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest = {
    import UpdateItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .key(
        key
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        attributeUpdates.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.attributeUpdates)
      .optionallyWith(
        expected.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.expected)
      .optionallyWith(conditionalOperator.map(value => value.unwrap))(
        _.conditionalOperator
      )
      .optionallyWith(returnValues.map(value => value.unwrap))(_.returnValues)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(returnItemCollectionMetrics.map(value => value.unwrap))(
        _.returnItemCollectionMetrics
      )
      .optionallyWith(
        updateExpression.map(value =>
          UpdateExpression.unwrap(value): java.lang.String
        )
      )(_.updateExpression)
      .optionallyWith(
        conditionExpression.map(value =>
          ConditionExpression.unwrap(value): java.lang.String
        )
      )(_.conditionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable
                .unwrap(key): java.lang.String) -> (AttributeName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateItemRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateItemRequest.wrap(buildAwsValue())
}
object UpdateItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateItemRequest =
      zio.aws.dynamodb.model.UpdateItemRequest(
        tableName,
        key.map({ case (key, value) =>
          key -> value.asEditable
        }),
        attributeUpdates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        expected.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conditionalOperator.map(value => value),
        returnValues.map(value => value),
        returnConsumedCapacity.map(value => value),
        returnItemCollectionMetrics.map(value => value),
        updateExpression.map(value => value),
        conditionExpression.map(value => value),
        expressionAttributeNames.map(value => value),
        expressionAttributeValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def tableName: TableName
    def key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def attributeUpdates: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValueUpdate.ReadOnly]
    ]
    def expected: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly]
    ]
    def conditionalOperator
        : Optional[zio.aws.dynamodb.model.ConditionalOperator]
    def returnValues: Optional[zio.aws.dynamodb.model.ReturnValue]
    def returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def returnItemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ReturnItemCollectionMetrics]
    def updateExpression: Optional[UpdateExpression]
    def conditionExpression: Optional[ConditionExpression]
    def expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getKey: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(key)
    def getAttributeUpdates: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValueUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeUpdates", attributeUpdates)
    def getExpected: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("expected", expected)
    def getConditionalOperator
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionalOperator] =
      AwsError.unwrapOptionField("conditionalOperator", conditionalOperator)
    def getReturnValues
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnValue] =
      AwsError.unwrapOptionField("returnValues", returnValues)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getReturnItemCollectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = AwsError.unwrapOptionField(
      "returnItemCollectionMetrics",
      returnItemCollectionMetrics
    )
    def getUpdateExpression: ZIO[Any, AwsError, UpdateExpression] =
      AwsError.unwrapOptionField("updateExpression", updateExpression)
    def getConditionExpression: ZIO[Any, AwsError, ConditionExpression] =
      AwsError.unwrapOptionField("conditionExpression", conditionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest
  ) extends zio.aws.dynamodb.model.UpdateItemRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val key
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .key()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
    override val attributeUpdates: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValueUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeUpdates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValueUpdate.wrap(value)
          })
          .toMap
      )
    override val expected: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expected())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.ExpectedAttributeValue.wrap(value)
          })
          .toMap
      )
    override val conditionalOperator
        : Optional[zio.aws.dynamodb.model.ConditionalOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalOperator())
        .map(value => zio.aws.dynamodb.model.ConditionalOperator.wrap(value))
    override val returnValues: Optional[zio.aws.dynamodb.model.ReturnValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnValues())
        .map(value => zio.aws.dynamodb.model.ReturnValue.wrap(value))
    override val returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnConsumedCapacity())
        .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val returnItemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ReturnItemCollectionMetrics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnItemCollectionMetrics())
        .map(value =>
          zio.aws.dynamodb.model.ReturnItemCollectionMetrics.wrap(value)
        )
    override val updateExpression: Optional[UpdateExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateExpression())
        .map(value => zio.aws.dynamodb.model.primitives.UpdateExpression(value))
    override val conditionExpression: Optional[ConditionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionExpression())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConditionExpression(value)
        )
    override val expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expressionAttributeNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
                key
              ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
            })
            .toMap
        )
    override val expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest
  ): zio.aws.dynamodb.model.UpdateItemRequest.ReadOnly = new Wrapper(impl)
}
