package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, IndexName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalTableGlobalSecondaryIndexSettingsUpdate(
    indexName: IndexName,
    provisionedWriteCapacityUnits: Optional[PositiveLongObject] =
      Optional.Absent,
    provisionedWriteCapacityAutoScalingSettingsUpdate: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate = {
    import GlobalTableGlobalSecondaryIndexSettingsUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        provisionedWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.provisionedWriteCapacityUnits)
      .optionallyWith(
        provisionedWriteCapacityAutoScalingSettingsUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedWriteCapacityAutoScalingSettingsUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly =
    zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
      .wrap(buildAwsValue())
}
object GlobalTableGlobalSecondaryIndexSettingsUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate =
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate(
        indexName,
        provisionedWriteCapacityUnits.map(value => value),
        provisionedWriteCapacityAutoScalingSettingsUpdate.map(value =>
          value.asEditable
        )
      )
    def indexName: IndexName
    def provisionedWriteCapacityUnits: Optional[PositiveLongObject]
    def provisionedWriteCapacityAutoScalingSettingsUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityUnits",
      provisionedWriteCapacityUnits
    )
    def getProvisionedWriteCapacityAutoScalingSettingsUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityAutoScalingSettingsUpdate",
      provisionedWriteCapacityAutoScalingSettingsUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
  ) extends zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val provisionedWriteCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedWriteCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val provisionedWriteCapacityAutoScalingSettingsUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.provisionedWriteCapacityAutoScalingSettingsUpdate()
        )
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
  ): zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly =
    new Wrapper(impl)
}
