package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  AutoScalingRoleArn,
  BooleanObject,
  PositiveLongObject
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoScalingSettingsUpdate(
    minimumUnits: Optional[PositiveLongObject] = Optional.Absent,
    maximumUnits: Optional[PositiveLongObject] = Optional.Absent,
    autoScalingDisabled: Optional[BooleanObject] = Optional.Absent,
    autoScalingRoleArn: Optional[AutoScalingRoleArn] = Optional.Absent,
    scalingPolicyUpdate: Optional[
      zio.aws.dynamodb.model.AutoScalingPolicyUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate = {
    import AutoScalingSettingsUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
      .builder()
      .optionallyWith(
        minimumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.minimumUnits)
      .optionallyWith(
        maximumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.maximumUnits)
      .optionallyWith(
        autoScalingDisabled.map(value => value: java.lang.Boolean)
      )(_.autoScalingDisabled)
      .optionallyWith(
        autoScalingRoleArn.map(value =>
          AutoScalingRoleArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingRoleArn)
      .optionallyWith(scalingPolicyUpdate.map(value => value.buildAwsValue()))(
        _.scalingPolicyUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(buildAwsValue())
}
object AutoScalingSettingsUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AutoScalingSettingsUpdate =
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate(
        minimumUnits.map(value => value),
        maximumUnits.map(value => value),
        autoScalingDisabled.map(value => value),
        autoScalingRoleArn.map(value => value),
        scalingPolicyUpdate.map(value => value.asEditable)
      )
    def minimumUnits: Optional[PositiveLongObject]
    def maximumUnits: Optional[PositiveLongObject]
    def autoScalingDisabled: Optional[BooleanObject]
    def autoScalingRoleArn: Optional[AutoScalingRoleArn]
    def scalingPolicyUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly]
    def getMinimumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("minimumUnits", minimumUnits)
    def getMaximumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("maximumUnits", maximumUnits)
    def getAutoScalingDisabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingDisabled", autoScalingDisabled)
    def getAutoScalingRoleArn: ZIO[Any, AwsError, AutoScalingRoleArn] =
      AwsError.unwrapOptionField("autoScalingRoleArn", autoScalingRoleArn)
    def getScalingPolicyUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("scalingPolicyUpdate", scalingPolicyUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
  ) extends zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly {
    override val minimumUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val maximumUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val autoScalingDisabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingDisabled())
        .map(value => value: BooleanObject)
    override val autoScalingRoleArn: Optional[AutoScalingRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingRoleArn())
        .map(value =>
          zio.aws.dynamodb.model.primitives.AutoScalingRoleArn(value)
        )
    override val scalingPolicyUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPolicyUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingPolicyUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
  ): zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly = new Wrapper(
    impl
  )
}
