package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ItemCollectionSizeEstimateBound,
  AttributeName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ItemCollectionMetrics(
    itemCollectionKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = Optional.Absent,
    sizeEstimateRangeGB: Optional[Iterable[ItemCollectionSizeEstimateBound]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics = {
    import ItemCollectionMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics
      .builder()
      .optionallyWith(
        itemCollectionKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.itemCollectionKey)
      .optionallyWith(
        sizeEstimateRangeGB.map(value =>
          value.map { item =>
            ItemCollectionSizeEstimateBound.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.sizeEstimateRangeGB)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly =
    zio.aws.dynamodb.model.ItemCollectionMetrics.wrap(buildAwsValue())
}
object ItemCollectionMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ItemCollectionMetrics =
      zio.aws.dynamodb.model.ItemCollectionMetrics(
        itemCollectionKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        sizeEstimateRangeGB.map(value => value)
      )
    def itemCollectionKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def sizeEstimateRangeGB: Optional[List[ItemCollectionSizeEstimateBound]]
    def getItemCollectionKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("itemCollectionKey", itemCollectionKey)
    def getSizeEstimateRangeGB
        : ZIO[Any, AwsError, List[ItemCollectionSizeEstimateBound]] =
      AwsError.unwrapOptionField("sizeEstimateRangeGB", sizeEstimateRangeGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics
  ) extends zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly {
    override val itemCollectionKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCollectionKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val sizeEstimateRangeGB
        : Optional[List[ItemCollectionSizeEstimateBound]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeEstimateRangeGB())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.primitives
              .ItemCollectionSizeEstimateBound(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics
  ): zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly = new Wrapper(impl)
}
