package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{IndexName, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateContributorInsightsRequest(
    tableName: TableName,
    indexName: Optional[IndexName] = Optional.Absent,
    contributorInsightsAction: zio.aws.dynamodb.model.ContributorInsightsAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest = {
    import UpdateContributorInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .contributorInsightsAction(contributorInsightsAction.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateContributorInsightsRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateContributorInsightsRequest
      .wrap(buildAwsValue())
}
object UpdateContributorInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateContributorInsightsRequest =
      zio.aws.dynamodb.model.UpdateContributorInsightsRequest(
        tableName,
        indexName.map(value => value),
        contributorInsightsAction
      )
    def tableName: TableName
    def indexName: Optional[IndexName]
    def contributorInsightsAction
        : zio.aws.dynamodb.model.ContributorInsightsAction
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getContributorInsightsAction
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.ContributorInsightsAction] =
      ZIO.succeed(contributorInsightsAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest
  ) extends zio.aws.dynamodb.model.UpdateContributorInsightsRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val contributorInsightsAction
        : zio.aws.dynamodb.model.ContributorInsightsAction =
      zio.aws.dynamodb.model.ContributorInsightsAction
        .wrap(impl.contributorInsightsAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest
  ): zio.aws.dynamodb.model.UpdateContributorInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
