package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait SSEType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.SSEType
}
object SSEType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.SSEType
  ): zio.aws.dynamodb.model.SSEType = value match {
    case software.amazon.awssdk.services.dynamodb.model.SSEType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEType.AES256 =>
      val r = AES256
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEType.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.SSEType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEType =
      software.amazon.awssdk.services.dynamodb.model.SSEType.UNKNOWN_TO_SDK_VERSION
  }
  case object AES256 extends zio.aws.dynamodb.model.SSEType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEType =
      software.amazon.awssdk.services.dynamodb.model.SSEType.AES256
  }
  case object KMS extends zio.aws.dynamodb.model.SSEType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEType =
      software.amazon.awssdk.services.dynamodb.model.SSEType.KMS
  }
}
