package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.NextTokenString
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListContributorInsightsResponse(
    contributorInsightsSummaries: Optional[
      Iterable[zio.aws.dynamodb.model.ContributorInsightsSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse = {
    import ListContributorInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
      .builder()
      .optionallyWith(
        contributorInsightsSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contributorInsightsSummaries)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly =
    zio.aws.dynamodb.model.ListContributorInsightsResponse.wrap(buildAwsValue())
}
object ListContributorInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListContributorInsightsResponse =
      zio.aws.dynamodb.model.ListContributorInsightsResponse(
        contributorInsightsSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contributorInsightsSummaries: Optional[
      List[zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly]
    ]
    def nextToken: Optional[NextTokenString]
    def getContributorInsightsSummaries: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "contributorInsightsSummaries",
      contributorInsightsSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
  ) extends zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly {
    override val contributorInsightsSummaries: Optional[
      List[zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contributorInsightsSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ContributorInsightsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
  ): zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
