package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class BatchWriteItemResponse(
    unprocessedItems: Option[
      Map[TableName, Iterable[zio.aws.dynamodb.model.WriteRequest]]
    ] = None,
    itemCollectionMetrics: Option[
      Map[TableName, Iterable[zio.aws.dynamodb.model.ItemCollectionMetrics]]
    ] = None,
    consumedCapacity: Option[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse = {
    import BatchWriteItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse
      .builder()
      .optionallyWith(
        unprocessedItems.map(value =>
          value
            .map({ case (key, value) =>
              (TableName.unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.unprocessedItems)
      .optionallyWith(
        itemCollectionMetrics.map(value =>
          value
            .map({ case (key, value) =>
              (TableName.unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.itemCollectionMetrics)
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchWriteItemResponse.ReadOnly =
    zio.aws.dynamodb.model.BatchWriteItemResponse.wrap(buildAwsValue())
}
object BatchWriteItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchWriteItemResponse =
      zio.aws.dynamodb.model.BatchWriteItemResponse(
        unprocessedItems.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        itemCollectionMetrics.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedItems: Option[
      Map[TableName, List[zio.aws.dynamodb.model.WriteRequest.ReadOnly]]
    ]
    def itemCollectionMetrics: Option[Map[TableName, List[
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ]]]
    def consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def getUnprocessedItems: ZIO[Any, AwsError, Map[TableName, List[
      zio.aws.dynamodb.model.WriteRequest.ReadOnly
    ]]] = AwsError.unwrapOptionField("unprocessedItems", unprocessedItems)
    def getItemCollectionMetrics: ZIO[Any, AwsError, Map[TableName, List[
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ]]] =
      AwsError.unwrapOptionField("itemCollectionMetrics", itemCollectionMetrics)
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse
  ) extends zio.aws.dynamodb.model.BatchWriteItemResponse.ReadOnly {
    override val unprocessedItems: Option[
      Map[TableName, List[zio.aws.dynamodb.model.WriteRequest.ReadOnly]]
    ] = scala
      .Option(impl.unprocessedItems())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives
              .TableName(key) -> value.asScala.map { item =>
              zio.aws.dynamodb.model.WriteRequest.wrap(item)
            }.toList
          })
          .toMap
      )
    override val itemCollectionMetrics: Option[Map[TableName, List[
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ]]] = scala
      .Option(impl.itemCollectionMetrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives
              .TableName(key) -> value.asScala.map { item =>
              zio.aws.dynamodb.model.ItemCollectionMetrics.wrap(item)
            }.toList
          })
          .toMap
      )
    override val consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] = scala
      .Option(impl.consumedCapacity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse
  ): zio.aws.dynamodb.model.BatchWriteItemResponse.ReadOnly = new Wrapper(impl)
}
