package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class UpdateTableRequest(
    attributeDefinitions: Option[
      Iterable[zio.aws.dynamodb.model.AttributeDefinition]
    ] = None,
    tableName: TableName,
    billingMode: Option[zio.aws.dynamodb.model.BillingMode] = None,
    provisionedThroughput: Option[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = None,
    globalSecondaryIndexUpdates: Option[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate]
    ] = None,
    streamSpecification: Option[zio.aws.dynamodb.model.StreamSpecification] =
      None,
    sseSpecification: Option[zio.aws.dynamodb.model.SSESpecification] = None,
    replicaUpdates: Option[
      Iterable[zio.aws.dynamodb.model.ReplicationGroupUpdate]
    ] = None,
    tableClass: Option[zio.aws.dynamodb.model.TableClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest = {
    import UpdateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
      .builder()
      .optionallyWith(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeDefinitions)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(
        globalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexUpdates)
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .optionallyWith(
        replicaUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaUpdates)
      .optionallyWith(tableClass.map(value => value.unwrap))(_.tableClass)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateTableRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateTableRequest.wrap(buildAwsValue())
}
object UpdateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateTableRequest =
      zio.aws.dynamodb.model.UpdateTableRequest(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableName,
        billingMode.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        globalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamSpecification.map(value => value.asEditable),
        sseSpecification.map(value => value.asEditable),
        replicaUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableClass.map(value => value)
      )
    def attributeDefinitions
        : Option[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]]
    def tableName: TableName
    def billingMode: Option[zio.aws.dynamodb.model.BillingMode]
    def provisionedThroughput
        : Option[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def globalSecondaryIndexUpdates: Option[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly]
    ]
    def streamSpecification
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def sseSpecification
        : Option[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def replicaUpdates
        : Option[List[zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly]]
    def tableClass: Option[zio.aws.dynamodb.model.TableClass]
    def getAttributeDefinitions: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("attributeDefinitions", attributeDefinitions)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getGlobalSecondaryIndexUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexUpdates",
      globalSecondaryIndexUpdates
    )
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getSseSpecification
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField("sseSpecification", sseSpecification)
    def getReplicaUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("replicaUpdates", replicaUpdates)
    def getTableClass: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClass", tableClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
  ) extends zio.aws.dynamodb.model.UpdateTableRequest.ReadOnly {
    override val attributeDefinitions
        : Option[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]] =
      scala
        .Option(impl.attributeDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
          }.toList
        )
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val billingMode: Option[zio.aws.dynamodb.model.BillingMode] = scala
      .Option(impl.billingMode())
      .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val provisionedThroughput
        : Option[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] = scala
      .Option(impl.provisionedThroughput())
      .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val globalSecondaryIndexUpdates: Option[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly]
    ] = scala
      .Option(impl.globalSecondaryIndexUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.wrap(item)
        }.toList
      )
    override val streamSpecification
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] = scala
      .Option(impl.streamSpecification())
      .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val sseSpecification
        : Option[zio.aws.dynamodb.model.SSESpecification.ReadOnly] = scala
      .Option(impl.sseSpecification())
      .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
    override val replicaUpdates
        : Option[List[zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly]] =
      scala
        .Option(impl.replicaUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ReplicationGroupUpdate.wrap(item)
          }.toList
        )
    override val tableClass: Option[zio.aws.dynamodb.model.TableClass] = scala
      .Option(impl.tableClass())
      .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
  ): zio.aws.dynamodb.model.UpdateTableRequest.ReadOnly = new Wrapper(impl)
}
