package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{Date, KMSMasterKeyArn}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SSEDescription(
    status: Option[zio.aws.dynamodb.model.SSEStatus] = None,
    sseType: Option[zio.aws.dynamodb.model.SSEType] = None,
    kmsMasterKeyArn: Option[KMSMasterKeyArn] = None,
    inaccessibleEncryptionDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.SSEDescription = {
    import SSEDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.SSEDescription
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sseType.map(value => value.unwrap))(_.sseType)
      .optionallyWith(
        kmsMasterKeyArn.map(value =>
          KMSMasterKeyArn.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyArn)
      .optionallyWith(
        inaccessibleEncryptionDateTime.map(value => Date.unwrap(value): Instant)
      )(_.inaccessibleEncryptionDateTime)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.SSEDescription.ReadOnly =
    zio.aws.dynamodb.model.SSEDescription.wrap(buildAwsValue())
}
object SSEDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.SSEDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.SSEDescription =
      zio.aws.dynamodb.model.SSEDescription(
        status.map(value => value),
        sseType.map(value => value),
        kmsMasterKeyArn.map(value => value),
        inaccessibleEncryptionDateTime.map(value => value)
      )
    def status: Option[zio.aws.dynamodb.model.SSEStatus]
    def sseType: Option[zio.aws.dynamodb.model.SSEType]
    def kmsMasterKeyArn: Option[KMSMasterKeyArn]
    def inaccessibleEncryptionDateTime: Option[Date]
    def getStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.SSEStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSseType: ZIO[Any, AwsError, zio.aws.dynamodb.model.SSEType] =
      AwsError.unwrapOptionField("sseType", sseType)
    def getKmsMasterKeyArn: ZIO[Any, AwsError, KMSMasterKeyArn] =
      AwsError.unwrapOptionField("kmsMasterKeyArn", kmsMasterKeyArn)
    def getInaccessibleEncryptionDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "inaccessibleEncryptionDateTime",
        inaccessibleEncryptionDateTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.SSEDescription
  ) extends zio.aws.dynamodb.model.SSEDescription.ReadOnly {
    override val status: Option[zio.aws.dynamodb.model.SSEStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.dynamodb.model.SSEStatus.wrap(value))
    override val sseType: Option[zio.aws.dynamodb.model.SSEType] = scala
      .Option(impl.sseType())
      .map(value => zio.aws.dynamodb.model.SSEType.wrap(value))
    override val kmsMasterKeyArn: Option[KMSMasterKeyArn] = scala
      .Option(impl.kmsMasterKeyArn())
      .map(value => zio.aws.dynamodb.model.primitives.KMSMasterKeyArn(value))
    override val inaccessibleEncryptionDateTime: Option[Date] = scala
      .Option(impl.inaccessibleEncryptionDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.SSEDescription
  ): zio.aws.dynamodb.model.SSEDescription.ReadOnly = new Wrapper(impl)
}
