package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.NextTokenString
import scala.jdk.CollectionConverters.*
final case class ListContributorInsightsResponse(
    contributorInsightsSummaries: Option[
      Iterable[zio.aws.dynamodb.model.ContributorInsightsSummary]
    ] = None,
    nextToken: Option[NextTokenString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse = {
    import ListContributorInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
      .builder()
      .optionallyWith(
        contributorInsightsSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contributorInsightsSummaries)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly =
    zio.aws.dynamodb.model.ListContributorInsightsResponse.wrap(buildAwsValue())
}
object ListContributorInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListContributorInsightsResponse =
      zio.aws.dynamodb.model.ListContributorInsightsResponse(
        contributorInsightsSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contributorInsightsSummaries: Option[
      List[zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly]
    ]
    def nextToken: Option[NextTokenString]
    def getContributorInsightsSummaries: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "contributorInsightsSummaries",
      contributorInsightsSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
  ) extends zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly {
    override val contributorInsightsSummaries: Option[
      List[zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly]
    ] = scala
      .Option(impl.contributorInsightsSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ContributorInsightsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextTokenString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse
  ): zio.aws.dynamodb.model.ListContributorInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
