package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait BillingMode {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.BillingMode
}
object BillingMode {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.BillingMode
  ): zio.aws.dynamodb.model.BillingMode = value match {
    case software.amazon.awssdk.services.dynamodb.model.BillingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.BillingMode.PROVISIONED =>
      val r = PROVISIONED
      r
    case software.amazon.awssdk.services.dynamodb.model.BillingMode.PAY_PER_REQUEST =>
      val r = PAY_PER_REQUEST
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.BillingMode {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BillingMode =
      software.amazon.awssdk.services.dynamodb.model.BillingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONED extends zio.aws.dynamodb.model.BillingMode {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BillingMode =
      software.amazon.awssdk.services.dynamodb.model.BillingMode.PROVISIONED
  }
  case object PAY_PER_REQUEST extends zio.aws.dynamodb.model.BillingMode {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BillingMode =
      software.amazon.awssdk.services.dynamodb.model.BillingMode.PAY_PER_REQUEST
  }
}
