package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  PositiveIntegerObject,
  IndexName,
  TableName,
  KeyExpression,
  ProjectionExpression,
  AttributeName,
  ConsistentRead,
  BooleanObject,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ExpressionAttributeValueVariable
}
import scala.jdk.CollectionConverters.*
final case class QueryRequest(
    tableName: TableName,
    indexName: Option[IndexName] = None,
    select: Option[zio.aws.dynamodb.model.Select] = None,
    attributesToGet: Option[Iterable[AttributeName]] = None,
    limit: Option[PositiveIntegerObject] = None,
    consistentRead: Option[ConsistentRead] = None,
    keyConditions: Option[
      Map[AttributeName, zio.aws.dynamodb.model.Condition]
    ] = None,
    queryFilter: Option[Map[AttributeName, zio.aws.dynamodb.model.Condition]] =
      None,
    conditionalOperator: Option[zio.aws.dynamodb.model.ConditionalOperator] =
      None,
    scanIndexForward: Option[BooleanObject] = None,
    exclusiveStartKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = None,
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None,
    projectionExpression: Option[ProjectionExpression] = None,
    filterExpression: Option[ConditionExpression] = None,
    keyConditionExpression: Option[KeyExpression] = None,
    expressionAttributeNames: Option[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = None,
    expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.QueryRequest = {
    import QueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.QueryRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(select.map(value => value.unwrap))(_.select)
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .optionallyWith(
        keyConditions.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.keyConditions)
      .optionallyWith(
        queryFilter.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.queryFilter)
      .optionallyWith(conditionalOperator.map(value => value.unwrap))(
        _.conditionalOperator
      )
      .optionallyWith(scanIndexForward.map(value => value: java.lang.Boolean))(
        _.scanIndexForward
      )
      .optionallyWith(
        exclusiveStartKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.exclusiveStartKey)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(
        projectionExpression.map(value =>
          ProjectionExpression.unwrap(value): java.lang.String
        )
      )(_.projectionExpression)
      .optionallyWith(
        filterExpression.map(value =>
          ConditionExpression.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(
        keyConditionExpression.map(value =>
          KeyExpression.unwrap(value): java.lang.String
        )
      )(_.keyConditionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable
                .unwrap(key): java.lang.String) -> (AttributeName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.QueryRequest.ReadOnly =
    zio.aws.dynamodb.model.QueryRequest.wrap(buildAwsValue())
}
object QueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.QueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.QueryRequest =
      zio.aws.dynamodb.model.QueryRequest(
        tableName,
        indexName.map(value => value),
        select.map(value => value),
        attributesToGet.map(value => value),
        limit.map(value => value),
        consistentRead.map(value => value),
        keyConditions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        queryFilter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conditionalOperator.map(value => value),
        scanIndexForward.map(value => value),
        exclusiveStartKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        returnConsumedCapacity.map(value => value),
        projectionExpression.map(value => value),
        filterExpression.map(value => value),
        keyConditionExpression.map(value => value),
        expressionAttributeNames.map(value => value),
        expressionAttributeValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def tableName: TableName
    def indexName: Option[IndexName]
    def select: Option[zio.aws.dynamodb.model.Select]
    def attributesToGet: Option[List[AttributeName]]
    def limit: Option[PositiveIntegerObject]
    def consistentRead: Option[ConsistentRead]
    def keyConditions
        : Option[Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]]
    def queryFilter
        : Option[Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]]
    def conditionalOperator: Option[zio.aws.dynamodb.model.ConditionalOperator]
    def scanIndexForward: Option[BooleanObject]
    def exclusiveStartKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def projectionExpression: Option[ProjectionExpression]
    def filterExpression: Option[ConditionExpression]
    def keyConditionExpression: Option[KeyExpression]
    def expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getSelect: ZIO[Any, AwsError, zio.aws.dynamodb.model.Select] =
      AwsError.unwrapOptionField("select", select)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
    def getKeyConditions: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.Condition.ReadOnly
    ]] = AwsError.unwrapOptionField("keyConditions", keyConditions)
    def getQueryFilter: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.Condition.ReadOnly
    ]] = AwsError.unwrapOptionField("queryFilter", queryFilter)
    def getConditionalOperator
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionalOperator] =
      AwsError.unwrapOptionField("conditionalOperator", conditionalOperator)
    def getScanIndexForward: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("scanIndexForward", scanIndexForward)
    def getExclusiveStartKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("exclusiveStartKey", exclusiveStartKey)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getProjectionExpression: ZIO[Any, AwsError, ProjectionExpression] =
      AwsError.unwrapOptionField("projectionExpression", projectionExpression)
    def getFilterExpression: ZIO[Any, AwsError, ConditionExpression] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getKeyConditionExpression: ZIO[Any, AwsError, KeyExpression] = AwsError
      .unwrapOptionField("keyConditionExpression", keyConditionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.QueryRequest
  ) extends zio.aws.dynamodb.model.QueryRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val select: Option[zio.aws.dynamodb.model.Select] = scala
      .Option(impl.select())
      .map(value => zio.aws.dynamodb.model.Select.wrap(value))
    override val attributesToGet: Option[List[AttributeName]] = scala
      .Option(impl.attributesToGet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.AttributeName(item)
        }.toList
      )
    override val limit: Option[PositiveIntegerObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.PositiveIntegerObject(value)
      )
    override val consistentRead: Option[ConsistentRead] = scala
      .Option(impl.consistentRead())
      .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
    override val keyConditions: Option[
      Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]
    ] = scala
      .Option(impl.keyConditions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.Condition.wrap(value)
          })
          .toMap
      )
    override val queryFilter: Option[
      Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]
    ] = scala
      .Option(impl.queryFilter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.Condition.wrap(value)
          })
          .toMap
      )
    override val conditionalOperator
        : Option[zio.aws.dynamodb.model.ConditionalOperator] = scala
      .Option(impl.conditionalOperator())
      .map(value => zio.aws.dynamodb.model.ConditionalOperator.wrap(value))
    override val scanIndexForward: Option[BooleanObject] =
      scala.Option(impl.scanIndexForward()).map(value => value: BooleanObject)
    override val exclusiveStartKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.exclusiveStartKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val projectionExpression: Option[ProjectionExpression] = scala
      .Option(impl.projectionExpression())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ProjectionExpression(value)
      )
    override val filterExpression: Option[ConditionExpression] = scala
      .Option(impl.filterExpression())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConditionExpression(value)
      )
    override val keyConditionExpression: Option[KeyExpression] = scala
      .Option(impl.keyConditionExpression())
      .map(value => zio.aws.dynamodb.model.primitives.KeyExpression(value))
    override val expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]] = scala
      .Option(impl.expressionAttributeNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
              key
            ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
          })
          .toMap
      )
    override val expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = scala
      .Option(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.QueryRequest
  ): zio.aws.dynamodb.model.QueryRequest.ReadOnly = new Wrapper(impl)
}
