package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ExportArn
import scala.jdk.CollectionConverters.*
final case class ExportSummary(
    exportArn: Option[ExportArn] = None,
    exportStatus: Option[zio.aws.dynamodb.model.ExportStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExportSummary = {
    import ExportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExportSummary
      .builder()
      .optionallyWith(
        exportArn.map(value => ExportArn.unwrap(value): java.lang.String)
      )(_.exportArn)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExportSummary.ReadOnly =
    zio.aws.dynamodb.model.ExportSummary.wrap(buildAwsValue())
}
object ExportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExportSummary =
      zio.aws.dynamodb.model.ExportSummary(
        exportArn.map(value => value),
        exportStatus.map(value => value)
      )
    def exportArn: Option[ExportArn]
    def exportStatus: Option[zio.aws.dynamodb.model.ExportStatus]
    def getExportArn: ZIO[Any, AwsError, ExportArn] =
      AwsError.unwrapOptionField("exportArn", exportArn)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportSummary
  ) extends zio.aws.dynamodb.model.ExportSummary.ReadOnly {
    override val exportArn: Option[ExportArn] = scala
      .Option(impl.exportArn())
      .map(value => zio.aws.dynamodb.model.primitives.ExportArn(value))
    override val exportStatus: Option[zio.aws.dynamodb.model.ExportStatus] =
      scala
        .Option(impl.exportStatus())
        .map(value => zio.aws.dynamodb.model.ExportStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportSummary
  ): zio.aws.dynamodb.model.ExportSummary.ReadOnly = new Wrapper(impl)
}
