package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableName}
import scala.jdk.CollectionConverters.*
final case class EnableKinesisStreamingDestinationResponse(
    tableName: Option[TableName] = None,
    streamArn: Option[StreamArn] = None,
    destinationStatus: Option[zio.aws.dynamodb.model.DestinationStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse = {
    import EnableKinesisStreamingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(destinationStatus.map(value => value.unwrap))(
        _.destinationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly =
    zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse
      .wrap(buildAwsValue())
}
object EnableKinesisStreamingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse =
      zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse(
        tableName.map(value => value),
        streamArn.map(value => value),
        destinationStatus.map(value => value)
      )
    def tableName: Option[TableName]
    def streamArn: Option[StreamArn]
    def destinationStatus: Option[zio.aws.dynamodb.model.DestinationStatus]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDestinationStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.DestinationStatus] =
      AwsError.unwrapOptionField("destinationStatus", destinationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
  ) extends zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val destinationStatus
        : Option[zio.aws.dynamodb.model.DestinationStatus] = scala
      .Option(impl.destinationStatus())
      .map(value => zio.aws.dynamodb.model.DestinationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
  ): zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
