package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class DescribeKinesisStreamingDestinationResponse(
    tableName: Option[TableName] = None,
    kinesisDataStreamDestinations: Option[
      Iterable[zio.aws.dynamodb.model.KinesisDataStreamDestination]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse = {
    import DescribeKinesisStreamingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        kinesisDataStreamDestinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kinesisDataStreamDestinations)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse
      .wrap(buildAwsValue())
}
object DescribeKinesisStreamingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse =
      zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse(
        tableName.map(value => value),
        kinesisDataStreamDestinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tableName: Option[TableName]
    def kinesisDataStreamDestinations: Option[
      List[zio.aws.dynamodb.model.KinesisDataStreamDestination.ReadOnly]
    ]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getKinesisDataStreamDestinations: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KinesisDataStreamDestination.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "kinesisDataStreamDestinations",
      kinesisDataStreamDestinations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse
  ) extends zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val kinesisDataStreamDestinations: Option[
      List[zio.aws.dynamodb.model.KinesisDataStreamDestination.ReadOnly]
    ] = scala
      .Option(impl.kinesisDataStreamDestinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.KinesisDataStreamDestination.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse
  ): zio.aws.dynamodb.model.DescribeKinesisStreamingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
