package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeExportResponse(
    exportDescription: Option[zio.aws.dynamodb.model.ExportDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse = {
    import DescribeExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
      .builder()
      .optionallyWith(exportDescription.map(value => value.buildAwsValue()))(
        _.exportDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeExportResponse.wrap(buildAwsValue())
}
object DescribeExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeExportResponse =
      zio.aws.dynamodb.model.DescribeExportResponse(
        exportDescription.map(value => value.asEditable)
      )
    def exportDescription
        : Option[zio.aws.dynamodb.model.ExportDescription.ReadOnly]
    def getExportDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ExportDescription.ReadOnly
    ] = AwsError.unwrapOptionField("exportDescription", exportDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
  ) extends zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly {
    override val exportDescription
        : Option[zio.aws.dynamodb.model.ExportDescription.ReadOnly] = scala
      .Option(impl.exportDescription())
      .map(value => zio.aws.dynamodb.model.ExportDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse
  ): zio.aws.dynamodb.model.DescribeExportResponse.ReadOnly = new Wrapper(impl)
}
