package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.AutoScalingPolicyName
import scala.jdk.CollectionConverters.*
final case class AutoScalingPolicyUpdate(
    policyName: Option[AutoScalingPolicyName] = None,
    targetTrackingScalingPolicyConfiguration: zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate = {
    import AutoScalingPolicyUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate
      .builder()
      .optionallyWith(
        policyName.map(value =>
          AutoScalingPolicyName.unwrap(value): java.lang.String
        )
      )(_.policyName)
      .targetTrackingScalingPolicyConfiguration(
        targetTrackingScalingPolicyConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingPolicyUpdate.wrap(buildAwsValue())
}
object AutoScalingPolicyUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AutoScalingPolicyUpdate =
      zio.aws.dynamodb.model.AutoScalingPolicyUpdate(
        policyName.map(value => value),
        targetTrackingScalingPolicyConfiguration.asEditable
      )
    def policyName: Option[AutoScalingPolicyName]
    def targetTrackingScalingPolicyConfiguration
        : zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.ReadOnly
    def getPolicyName: ZIO[Any, AwsError, AutoScalingPolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getTargetTrackingScalingPolicyConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.ReadOnly
    ] = ZIO.succeed(targetTrackingScalingPolicyConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate
  ) extends zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly {
    override val policyName: Option[AutoScalingPolicyName] = scala
      .Option(impl.policyName())
      .map(value =>
        zio.aws.dynamodb.model.primitives.AutoScalingPolicyName(value)
      )
    override val targetTrackingScalingPolicyConfiguration
        : zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.ReadOnly =
      zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate
        .wrap(impl.targetTrackingScalingPolicyConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate
  ): zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly = new Wrapper(impl)
}
