package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.RegionName
import scala.jdk.CollectionConverters.*
final case class ReplicaAutoScalingUpdate(
    regionName: RegionName,
    replicaGlobalSecondaryIndexUpdates: Option[Iterable[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
    ]] = None,
    replicaProvisionedReadCapacityAutoScalingUpdate: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdate = {
    import ReplicaAutoScalingUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdate
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .optionallyWith(
        replicaGlobalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaGlobalSecondaryIndexUpdates)
      .optionallyWith(
        replicaProvisionedReadCapacityAutoScalingUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedReadCapacityAutoScalingUpdate)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.wrap(buildAwsValue())
}
object ReplicaAutoScalingUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaAutoScalingUpdate =
      zio.aws.dynamodb.model.ReplicaAutoScalingUpdate(
        regionName,
        replicaGlobalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaProvisionedReadCapacityAutoScalingUpdate.map(value =>
          value.asEditable
        )
      )
    def regionName: RegionName
    def replicaGlobalSecondaryIndexUpdates: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly
    ]]
    def replicaProvisionedReadCapacityAutoScalingUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
    def getReplicaGlobalSecondaryIndexUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicaGlobalSecondaryIndexUpdates",
      replicaGlobalSecondaryIndexUpdates
    )
    def getReplicaProvisionedReadCapacityAutoScalingUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedReadCapacityAutoScalingUpdate",
      replicaProvisionedReadCapacityAutoScalingUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdate
  ) extends zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
    override val replicaGlobalSecondaryIndexUpdates: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly
    ]] = scala
      .Option(impl.replicaGlobalSecondaryIndexUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
            .wrap(item)
        }.toList
      )
    override val replicaProvisionedReadCapacityAutoScalingUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      scala
        .Option(impl.replicaProvisionedReadCapacityAutoScalingUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdate
  ): zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.ReadOnly = new Wrapper(
    impl
  )
}
