package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.AttributeName
import scala.jdk.CollectionConverters.*
final case class PutRequest(
    item: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PutRequest = {
    import PutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PutRequest
      .builder()
      .item(
        item
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.PutRequest.ReadOnly =
    zio.aws.dynamodb.model.PutRequest.wrap(buildAwsValue())
}
object PutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PutRequest =
      zio.aws.dynamodb.model.PutRequest(item.map({ case (key, value) =>
        key -> value.asEditable
      }))
    def item: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def getItem: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PutRequest
  ) extends zio.aws.dynamodb.model.PutRequest.ReadOnly {
    override val item
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .item()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PutRequest
  ): zio.aws.dynamodb.model.PutRequest.ReadOnly = new Wrapper(impl)
}
