package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PositiveLongObject
import scala.jdk.CollectionConverters.*
final case class ProvisionedThroughputOverride(
    readCapacityUnits: Option[PositiveLongObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride = {
    import ProvisionedThroughputOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride
      .builder()
      .optionallyWith(
        readCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.readCapacityUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly =
    zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(buildAwsValue())
}
object ProvisionedThroughputOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ProvisionedThroughputOverride =
      zio.aws.dynamodb.model
        .ProvisionedThroughputOverride(readCapacityUnits.map(value => value))
    def readCapacityUnits: Option[PositiveLongObject]
    def getReadCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride
  ) extends zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly {
    override val readCapacityUnits: Option[PositiveLongObject] = scala
      .Option(impl.readCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride
  ): zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly =
    new Wrapper(impl)
}
