package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{TableName, Date, GlobalTableArnString}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GlobalTableDescription(
    replicationGroup: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaDescription]
    ] = None,
    globalTableArn: Option[GlobalTableArnString] = None,
    creationDateTime: Option[Date] = None,
    globalTableStatus: Option[zio.aws.dynamodb.model.GlobalTableStatus] = None,
    globalTableName: Option[TableName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription = {
    import GlobalTableDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription
      .builder()
      .optionallyWith(
        replicationGroup.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationGroup)
      .optionallyWith(
        globalTableArn.map(value =>
          GlobalTableArnString.unwrap(value): java.lang.String
        )
      )(_.globalTableArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(globalTableStatus.map(value => value.unwrap))(
        _.globalTableStatus
      )
      .optionallyWith(
        globalTableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.globalTableName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly =
    zio.aws.dynamodb.model.GlobalTableDescription.wrap(buildAwsValue())
}
object GlobalTableDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalTableDescription =
      zio.aws.dynamodb.model.GlobalTableDescription(
        replicationGroup.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalTableArn.map(value => value),
        creationDateTime.map(value => value),
        globalTableStatus.map(value => value),
        globalTableName.map(value => value)
      )
    def replicationGroup
        : Option[List[zio.aws.dynamodb.model.ReplicaDescription.ReadOnly]]
    def globalTableArn: Option[GlobalTableArnString]
    def creationDateTime: Option[Date]
    def globalTableStatus: Option[zio.aws.dynamodb.model.GlobalTableStatus]
    def globalTableName: Option[TableName]
    def getReplicationGroup: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationGroup", replicationGroup)
    def getGlobalTableArn: ZIO[Any, AwsError, GlobalTableArnString] =
      AwsError.unwrapOptionField("globalTableArn", globalTableArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getGlobalTableStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.GlobalTableStatus] =
      AwsError.unwrapOptionField("globalTableStatus", globalTableStatus)
    def getGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("globalTableName", globalTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription
  ) extends zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly {
    override val replicationGroup
        : Option[List[zio.aws.dynamodb.model.ReplicaDescription.ReadOnly]] =
      scala
        .Option(impl.replicationGroup())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ReplicaDescription.wrap(item)
          }.toList
        )
    override val globalTableArn: Option[GlobalTableArnString] = scala
      .Option(impl.globalTableArn())
      .map(value =>
        zio.aws.dynamodb.model.primitives.GlobalTableArnString(value)
      )
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val globalTableStatus
        : Option[zio.aws.dynamodb.model.GlobalTableStatus] = scala
      .Option(impl.globalTableStatus())
      .map(value => zio.aws.dynamodb.model.GlobalTableStatus.wrap(value))
    override val globalTableName: Option[TableName] = scala
      .Option(impl.globalTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription
  ): zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly = new Wrapper(impl)
}
