package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  PositiveIntegerObject,
  PartiQLNextToken,
  ConsistentRead,
  PartiQLStatement
}
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementRequest(
    statement: PartiQLStatement,
    parameters: Option[Iterable[zio.aws.dynamodb.model.AttributeValue]] = None,
    consistentRead: Option[ConsistentRead] = None,
    nextToken: Option[PartiQLNextToken] = None,
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None,
    limit: Option[PositiveIntegerObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest = {
    import ExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest
      .builder()
      .statement(PartiQLStatement.unwrap(statement): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .optionallyWith(
        nextToken.map(value => PartiQLNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExecuteStatementRequest.ReadOnly =
    zio.aws.dynamodb.model.ExecuteStatementRequest.wrap(buildAwsValue())
}
object ExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExecuteStatementRequest =
      zio.aws.dynamodb.model.ExecuteStatementRequest(
        statement,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consistentRead.map(value => value),
        nextToken.map(value => value),
        returnConsumedCapacity.map(value => value),
        limit.map(value => value)
      )
    def statement: PartiQLStatement
    def parameters: Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    def consistentRead: Option[ConsistentRead]
    def nextToken: Option[PartiQLNextToken]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def limit: Option[PositiveIntegerObject]
    def getStatement: ZIO[Any, Nothing, PartiQLStatement] =
      ZIO.succeed(statement)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
    def getNextToken: ZIO[Any, AwsError, PartiQLNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest
  ) extends zio.aws.dynamodb.model.ExecuteStatementRequest.ReadOnly {
    override val statement: PartiQLStatement =
      zio.aws.dynamodb.model.primitives.PartiQLStatement(impl.statement())
    override val parameters
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AttributeValue.wrap(item)
        }.toList
      )
    override val consistentRead: Option[ConsistentRead] = scala
      .Option(impl.consistentRead())
      .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
    override val nextToken: Option[PartiQLNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.PartiQLNextToken(value))
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val limit: Option[PositiveIntegerObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.PositiveIntegerObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest
  ): zio.aws.dynamodb.model.ExecuteStatementRequest.ReadOnly = new Wrapper(impl)
}
