package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{KMSMasterKeyId, RegionName}
import scala.jdk.CollectionConverters.*
final case class CreateReplicationGroupMemberAction(
    regionName: RegionName,
    kmsMasterKeyId: Option[KMSMasterKeyId] = None,
    provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = None,
    globalSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex]
    ] = None,
    tableClassOverride: Option[zio.aws.dynamodb.model.TableClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateReplicationGroupMemberAction = {
    import CreateReplicationGroupMemberAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateReplicationGroupMemberAction
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          KMSMasterKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(tableClassOverride.map(value => value.unwrap))(
        _.tableClassOverride
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.ReadOnly =
    zio.aws.dynamodb.model.CreateReplicationGroupMemberAction
      .wrap(buildAwsValue())
}
object CreateReplicationGroupMemberAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateReplicationGroupMemberAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateReplicationGroupMemberAction =
      zio.aws.dynamodb.model.CreateReplicationGroupMemberAction(
        regionName,
        kmsMasterKeyId.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableClassOverride.map(value => value)
      )
    def regionName: RegionName
    def kmsMasterKeyId: Option[KMSMasterKeyId]
    def provisionedThroughputOverride
        : Option[zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly]
    def globalSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly]
    ]
    def tableClassOverride: Option[zio.aws.dynamodb.model.TableClass]
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
    def getKmsMasterKeyId: ZIO[Any, AwsError, KMSMasterKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getTableClassOverride
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClassOverride", tableClassOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateReplicationGroupMemberAction
  ) extends zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
    override val kmsMasterKeyId: Option[KMSMasterKeyId] = scala
      .Option(impl.kmsMasterKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.KMSMasterKeyId(value))
    override val provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
    override val globalSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly]
    ] = scala
      .Option(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.wrap(item)
        }.toList
      )
    override val tableClassOverride: Option[zio.aws.dynamodb.model.TableClass] =
      scala
        .Option(impl.tableClassOverride())
        .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateReplicationGroupMemberAction
  ): zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.ReadOnly =
    new Wrapper(impl)
}
