package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{IntegerObject, BooleanObject}
import scala.jdk.CollectionConverters.*
final case class AutoScalingTargetTrackingScalingPolicyConfigurationDescription(
    disableScaleIn: Option[BooleanObject] = None,
    scaleInCooldown: Option[IntegerObject] = None,
    scaleOutCooldown: Option[IntegerObject] = None,
    targetValue: Double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription = {
    import AutoScalingTargetTrackingScalingPolicyConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
      .builder()
      .optionallyWith(disableScaleIn.map(value => value: java.lang.Boolean))(
        _.disableScaleIn
      )
      .optionallyWith(scaleInCooldown.map(value => value: Integer))(
        _.scaleInCooldown
      )
      .optionallyWith(scaleOutCooldown.map(value => value: Integer))(
        _.scaleOutCooldown
      )
      .targetValue(targetValue: java.lang.Double)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
      .wrap(buildAwsValue())
}
object AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription =
      zio.aws.dynamodb.model
        .AutoScalingTargetTrackingScalingPolicyConfigurationDescription(
          disableScaleIn.map(value => value),
          scaleInCooldown.map(value => value),
          scaleOutCooldown.map(value => value),
          targetValue
        )
    def disableScaleIn: Option[BooleanObject]
    def scaleInCooldown: Option[IntegerObject]
    def scaleOutCooldown: Option[IntegerObject]
    def targetValue: Double
    def getDisableScaleIn: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("disableScaleIn", disableScaleIn)
    def getScaleInCooldown: ZIO[Any, AwsError, IntegerObject] =
      AwsError.unwrapOptionField("scaleInCooldown", scaleInCooldown)
    def getScaleOutCooldown: ZIO[Any, AwsError, IntegerObject] =
      AwsError.unwrapOptionField("scaleOutCooldown", scaleOutCooldown)
    def getTargetValue: ZIO[Any, Nothing, Double] = ZIO.succeed(targetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
  ) extends zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription.ReadOnly {
    override val disableScaleIn: Option[BooleanObject] =
      scala.Option(impl.disableScaleIn()).map(value => value: BooleanObject)
    override val scaleInCooldown: Option[IntegerObject] =
      scala.Option(impl.scaleInCooldown()).map(value => value: IntegerObject)
    override val scaleOutCooldown: Option[IntegerObject] =
      scala.Option(impl.scaleOutCooldown()).map(value => value: IntegerObject)
    override val targetValue: Double = impl.targetValue(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
  ): zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
