package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreTableFromBackupResponse(
    tableDescription: Option[zio.aws.dynamodb.model.TableDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse = {
    import RestoreTableFromBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse
      .builder()
      .optionallyWith(tableDescription.map(value => value.buildAwsValue()))(
        _.tableDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.RestoreTableFromBackupResponse.ReadOnly =
    zio.aws.dynamodb.model.RestoreTableFromBackupResponse.wrap(buildAwsValue())
}
object RestoreTableFromBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.RestoreTableFromBackupResponse =
      zio.aws.dynamodb.model.RestoreTableFromBackupResponse(
        tableDescription.map(value => value.asEditable)
      )
    def tableDescription
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTableDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("tableDescription", tableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse
  ) extends zio.aws.dynamodb.model.RestoreTableFromBackupResponse.ReadOnly {
    override val tableDescription
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly] = scala
      .Option(impl.tableDescription())
      .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse
  ): zio.aws.dynamodb.model.RestoreTableFromBackupResponse.ReadOnly =
    new Wrapper(impl)
}
