package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.RegionName
import scala.jdk.CollectionConverters.*
final case class Replica(regionName: Option[RegionName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Replica = {
    import Replica.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Replica
      .builder()
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Replica.ReadOnly =
    zio.aws.dynamodb.model.Replica.wrap(buildAwsValue())
}
object Replica {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Replica] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Replica =
      zio.aws.dynamodb.model.Replica(regionName.map(value => value))
    def regionName: Option[RegionName]
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Replica
  ) extends zio.aws.dynamodb.model.Replica.ReadOnly {
    override val regionName: Option[RegionName] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.dynamodb.model.primitives.RegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Replica
  ): zio.aws.dynamodb.model.Replica.ReadOnly = new Wrapper(impl)
}
